//
//  ALFaceStarCollectionViewCell.m
//  GMAlpha
//
//  Created by Jing on 2018/11/26.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALFaceStarCollectionViewCell.h"
#import <GMKit/UIColor+GMTheme.h>

@interface ALFaceStarCollectionViewCell ()

@property (nonatomic, strong) UIImageView *starImageView;
@property (nonatomic, strong) UIImageView *editImageView;
@property (nonatomic, strong) UIImageView *lockImageView;
@property (nonatomic, strong) GMLabel *nameLabel;
@property (nonatomic, strong) GMLabel *similarityLabel;
@end

@implementation ALFaceStarCollectionViewCell

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self p_setup];
    }
    return self;
}

- (void)setModel:(ALFaceStarModel *)model {
    _model = model;
    _editImageView.hidden = YES;
    _nameLabel.hidden = NO;
    _lockImageView.hidden = !model.isLock;
    _similarityLabel.hidden = model.isLock;
    
    _nameLabel.text = model.name;
    [_starImageView sd_setImageWithURL:[NSURL URLWithString:model.starUrl] placeholderImage:[UIImage imageNamed:@"faceEditNormal"]];
    if (!model.isLock) {
        _similarityLabel.text = [NSString stringWithFormat:@"%@%%相似", model.similarScore];
    }
}

- (void)addCell {
    _starImageView.image = [UIImage imageNamed:@"faceFittingAddStar"];
    _nameLabel.hidden = _lockImageView.hidden = _similarityLabel.hidden = YES;
}

- (void)modifyDetails {
    _editImageView.hidden = !_editImageView.hidden;
}

- (BOOL)willModify {
    return !_editImageView.hidden;
}

- (void)p_setup {
    _starImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@""]];
    _starImageView.layer.cornerRadius = 45;
    _starImageView.layer.masksToBounds = YES;
    [self.contentView addSubview:_starImageView];
    [_starImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(90);
        make.height.mas_equalTo(90);
        make.top.equalTo(self.contentView);
        make.centerX.equalTo(self.contentView);
    }];
    
    _editImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"faceEdit"]];
    _editImageView.hidden = YES;
    [self.contentView addSubview:_editImageView];
    [_editImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.starImageView);
    }];
    
    _lockImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"faceFittingUnlockStar"]];
    _lockImageView.hidden = YES;
    [self.contentView addSubview:_lockImageView];
    [_lockImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(25);
        make.bottom.right.mas_equalTo(self.starImageView);
    }];
    
    _nameLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight fontSize:12];
    [self.contentView addSubview:_nameLabel];
    [_nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.starImageView.mas_bottom).offset(6);
        make.centerX.equalTo(self.editImageView);
        make.height.mas_equalTo(12);
    }];
    
    _similarityLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight fontSize:10];
    [self.contentView addSubview:_similarityLabel];
    [_similarityLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.nameLabel.mas_bottom).offset(3);
        make.centerX.equalTo(self.editImageView);
        make.height.mas_equalTo(10);
    }];
}

@end
