//
//  ALFaceSDK.h
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/29.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface ALFaceSDK : GMObject
/**
 * 获取UV图的定时器
 */
@property (nonatomic, strong) NSTimer *timer;

/**
 * 客户端数据上传
 * url              :  /api/v1/face/upload
 * raw_similar_data :  用户相似度的数据，二进制流数据(文件)
 * pre_uv_url       :  生成uv图片的URL(文件)
 * faceId           :  拟合ID
 * raw_pic          :  用户普通图片(文件)
 * create_uv        :  是否生成uv图片(int) 此参数2D传-->1  3D传-->0
 */
- (void)faceUploadRaw_similar_data:(NSString *)raw_similar_data pre_uv_url:(NSString *)pre_uv_url create_uv:(NSInteger)create_uv successBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock;
/**
 * 获取uv图
 * url              :  /api/v1/face/get_uv
 * faceId           :  拟合ID
 */
- (void)faceUploadSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock;

+ (void)downloadURL:(NSString *)downloadURL storePath:(NSString *)storePath progress:(void (^)(NSProgress *downloadProgress))progress destination:(void (^)(NSURL *targetPath))destination failure:(void(^)(NSError *error))faliure;

@end

