//
//  ALFaceSDK.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/29.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALFaceSDK.h"
#import "ALUpLoadManager.h"
#import "ALDownloadManager.h"
#import "ALFaceFittingAPI.h"

@implementation ALFaceSDK

/**
 * 客户端数据上传
 * url              :  /api/v1/face/upload
 * raw_similar_data :  用户相似度的数据，二进制流数据(文件)
 * faceId           :  拟合ID
 * raw_pic          :  用户普通图片(文件)
 * create_uv        :  是否生成uv图片(int) 此参数2D传-->1  3D传-->0
 */
- (void)faceUploadRaw_similar_data:(NSString *)raw_similar_data pre_uv_url:(NSString *)pre_uv_url create_uv:(NSInteger)create_uv successBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock
{
    NSString *fittingId = [ALScanManager.shareInstance.fittingTempId isNonEmpty] ? ALScanManager.shareInstance.fittingTempId : ALScanManager.shareInstance.fittingId;
    NSDictionary *params = @{
                             @"raw_similar_data":raw_similar_data,
                             @"id":SafeString(fittingId),
                             @"create_uv":@(create_uv),
                             @"pre_uv_url":pre_uv_url
                             };
    [GMNetworking requestOCWithApi:API_FACE_UPLOAD method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC *responseObject) {
        if (responseObject.isSuccess) {
            successBlock(responseObject);
            ALScanManager.shareInstance.fittingId = responseObject.data[@"id"];
            ALScanManager.shareInstance.fittingTempId = nil;
            [ALScanManager.shareInstance savePathInfo];
        } else {
            failBlock(responseObject.message);
        }
    }];
}

/**
 * 获取uv图
 * url              :  /api/v1/face/get_uv
 * faceId           :  拟合ID
 */
- (void)faceUploadSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock
{
    NSLog(@"%@",[GMLoginManager shareInstance].user);
    NSDictionary *params = @{@"id":SafeString(ALScanManager.shareInstance.fittingId),
                                 };
    [GMNetworking requestOCWithApi:API_FACE_GET_UV method:GMHTTPMethodGet parameters:params completion:^(GMResponseOC *responseObject) {
        if (responseObject.isSuccess) {
            successBlock(responseObject);
        } else {
            failBlock(responseObject.message);
        }
    }];
}

+ (void)fetchOutPutTxtWithUrl:(NSString *)url sotrePath:(NSString *)sotrePath completion:(ALFaceFittingDownloadStarCompletion)completion {
;
    [ALDownloadManager downloadTaskWithURL:url path:sotrePath completionHandler:^(NSURLResponse * _Nonnull response, NSURL * _Nullable filePath, NSError * _Nullable error) {
        if (!error ) {
             NSString *path = filePath.absoluteString;
            if (completion) {
                 [GMCache storeObjectAtDocumentPathWithkey:@"output" object:path];
                completion(sotrePath);
            };
        } else if (completion) completion(nil);
    }];
}

//全路径带名字的
+ (void)downloadURL:(NSString *)downloadURL storePath:(NSString *)storePath progress:(void (^)(NSProgress *downloadProgress))progress destination:(void (^)(NSURL *targetPath))destination failure:(void(^)(NSError *error))faliure{
    
    
    //1.创建管理者
    AFHTTPSessionManager *manage  = [AFHTTPSessionManager manager];
    
    //2.下载文件
    /*
     第一个参数：请求对象
     第二个参数：下载进度
     第三个参数：block回调，需要返回一个url地址，用来告诉AFN下载文件的目标地址
     targetPath：AFN内部下载文件存储的地址，tmp文件夹下
     response：请求的响应头
     返回值：文件应该剪切到什么地方
     第四个参数：block回调，当文件下载完成之后调用
     response：响应头
     filePath：文件存储在沙盒的地址 == 第三个参数中block的返回值
     error：错误信息
     */
    
    //2.1 创建请求对象
    NSURLRequest *request = [NSURLRequest requestWithURL:[NSURL URLWithString: downloadURL]];
    
    NSURLSessionDownloadTask *downloadTask = [manage downloadTaskWithRequest:request progress:^(NSProgress * _Nonnull downloadProgress) {//进度
        
        if (downloadProgress) {
            progress(downloadProgress);
        }
        
    } destination:^NSURL * _Nonnull(NSURL * _Nonnull targetPath, NSURLResponse * _Nonnull response) {
        NSURL *filePathUrl = [NSURL fileURLWithPath:storePath];
        return filePathUrl;
    } completionHandler:^(NSURLResponse * _Nonnull response, NSURL * _Nonnull filePath, NSError * _Nonnull error) {
        
        
        if (error) {
            faliure(error);
        }
        
        
        if(filePath){
            
            destination(filePath);
        }
    }];
    
    //3.启动任务
    [downloadTask resume];
}
@end
