//
//  ALRecommendFollowUserCell.h
//  GMAlpha
//
//  Created by Mikasa on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCardObject.h"

#define kItemWidth ((MAINSCREEN_WIDTH - 15 - 20) / 2.5)


@protocol ALRecommendFollowUserCellDelegate;

@interface ALRecommendFollowUserCell : GMCollectionViewCell
@property (nonatomic, strong) ALTopicCardRecommentObject *userObject;
@property (nonatomic, strong) NSIndexPath *indexPath;
@property (nonatomic, weak) id<ALRecommendFollowUserCellDelegate> delegate;
/** 点击关注用户 */
@property (nonatomic, copy) void(^didClickFollowUserBlock)();
@end


@protocol ALRecommendFollowUserCellDelegate <NSObject>
- (void)cell:(ALRecommendFollowUserCell *)view clickedIconAtIndexPath:(NSIndexPath *)indexPath;

/**
 触发了关注事件

 @param view self
 @param indexPath indexPath
 @param voteString 取值(@"do", @"undo"), do:关注, undo:取消关注
 */
- (void)cell:(ALRecommendFollowUserCell *)view clickedFollowAtIndexPath:(NSIndexPath *)indexPath voteString:(NSString *)voteString;
@end
