//
//  ALRecommendFollowUserCell.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRecommendFollowUserCell.h"
#import "ALPersonViewController.h"
@interface ALRecommendFollowUserCell ()

@property (nonatomic, strong) GMLabel *nameLabel;// 名称
@property (nonatomic, strong) GMLabel *followTipsLabel;// 她也关注
@property (nonatomic, strong) UIButton *followButton;// 关注按钮
@property (nonatomic, strong) GMImageView *iconImageView;// 头像

@end
@implementation ALRecommendFollowUserCell

- (void)setup {
    
    self.layer.cornerRadius = 5;
    self.layer.masksToBounds = YES;
    
    self.backgroundColor = [UIColor whiteColor];
    __weak __typeof(self)weakSelf = self;
    
    // 头像
    CGFloat imageWidth = kItemWidth - 60;
    CGFloat imageHeight = imageWidth;
    GMImageView *iconImageView = [[GMImageView alloc] initWithFrame:CGRectMake(30, 20, imageWidth, imageHeight)];
    iconImageView.image = [UIImage imageNamed:@"user_setter_default_icon_new"];
    iconImageView.layer.cornerRadius = imageHeight/2;
    iconImageView.layer.masksToBounds = YES;
    iconImageView.userInteractionEnabled = YES;
    UITapGestureRecognizer *gesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(iconImageViewClickMethod)];
    [iconImageView addGestureRecognizer:gesture];
    [self.contentView addSubview:iconImageView];
    self.iconImageView = iconImageView;
    [_iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(weakSelf.mas_centerX);
        make.width.height.mas_equalTo(imageWidth);
        make.top.mas_equalTo(10);
    }];
    
    
    // 名称
    GMLabel *nameLabel = [GMLabel labelWithTextColor:UIColor.headlineText
                                            fontSize:14];
    nameLabel.font = [UIFont gmBoldFont:14];
    nameLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:nameLabel];
    self.nameLabel = nameLabel;
    [_nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_iconImageView.mas_bottom).offset(15);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(14);
    }];
    
    // 也关注
    GMLabel *followTipsLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight
                                            fontSize:11];
    followTipsLabel.textAlignment = NSTextAlignmentCenter;
    followTipsLabel.text = @"她也关注";
    [self.contentView addSubview:followTipsLabel];
    self.followTipsLabel = followTipsLabel;
    [_followTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.top.mas_equalTo(_nameLabel.mas_bottom).offset(5);
        make.height.mas_equalTo(11);
    }];
    
    // 关注按钮
    UIButton *followButton = [[UIButton alloc] init];
    self.followButton = followButton;
    followButton.backgroundColor = RGBCOLOR_HEX(0x0093FF);
    followButton.layer.cornerRadius = 14;
    followButton.layer.masksToBounds = YES;
    [followButton setBackgroundImage:[UIImage imageWithColor:RGBCOLOR_HEX(0x0093FF)] forState:UIControlStateNormal];
    [followButton setBackgroundImage:[UIImage imageWithColor:RGBCOLOR_HEX(0xCCCCCC)] forState:UIControlStateSelected];
    [followButton setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
    [followButton setTitleColor:UIColor.auxiliaryTextLight forState:UIControlStateSelected];
    
    followButton.titleLabel.font = [UIFont gmFont:14];
    [followButton setTitle:@"关注" forState:UIControlStateNormal];
    [followButton setTitle:@"已关注" forState:UIControlStateSelected];
//    followButton.layer.borderColor = RGBCOLOR_HEX(0x0093FF).CGColor;
//    followButton.layer.borderWidth = ONE_PIXEL;
//    followButton.layer.cornerRadius = 12 * ONE_PIXEL;
//    followButton.layer.masksToBounds = YES;
    [followButton addTarget:self action:@selector(followButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    [followButton sizeToFit];
    [self.contentView addSubview:followButton];
    [_followButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.followTipsLabel.mas_bottom).offset(10);
        make.centerX.mas_equalTo(weakSelf.mas_centerX);
        make.width.mas_equalTo(118);
        make.height.mas_equalTo(28);
    }];
}

- (void)setUserObject:(ALTopicCardRecommentObject *)userObject {
    _userObject = userObject;
    UIImage *defIcon = [UIImage imageNamed:@"user_setter_default_icon_new"];
    NSURL *iconUrl = [NSURL URLWithString:userObject.icon];
    [self.iconImageView sd_setImageWithURL:iconUrl placeholderImage:defIcon];
    self.nameLabel.text = userObject.name;
    self.followTipsLabel.text = userObject.desc;
    self.followButton.selected = userObject.isFollow;
//    if (userObject.isFollow == YES)
//    {
//        self.followButton.layer.borderColor = UIColor.auxiliaryTextLight.CGColor;
//    }
//    else
//    {
//        self.followButton.layer.borderColor = [UIColor clearColor].CGColor;
//    }
    
}

#pragma mark - private method
- (void)followButtonClick:(UIButton *)sender {
    //用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    NSString *voteString = @"do";
    if (self.followButton.isSelected) {//已关注状态,只发送取消关注请求
        self.followButton.selected = NO;
        self.userObject.isFollow = NO;
        [self requestCancelFollowAuthor];
        voteString = @"undo";
    }else {
        [[NSNotificationCenter defaultCenter] postNotificationName:OTHERPERSON_ATTENTION_PERSON object:[NSString stringWithFormat:@"%zd",self.userObject.id]];
        self.followButton.selected = YES;
        self.userObject.isFollow = YES;
        [self requestAddFollowAuthor];
        voteString = @"do";
    }
    if ([self.delegate respondsToSelector:@selector(cell:clickedFollowAtIndexPath:voteString:)]) {
        [self.delegate cell:self clickedFollowAtIndexPath:self.indexPath voteString:voteString];
    }

}
#pragma mark - clickMethod

- (void)iconImageViewClickMethod
{
    [[NSNotificationCenter defaultCenter] postNotificationName:OTHERPERSON_CLICK_PERSONAVATAR object:[NSString stringWithFormat:@"%ld",(long)self.userObject.id]];
    ALPersonViewController *toVc = [[ALPersonViewController alloc] initWithUserId:self.userObject.id];
    [AppDelegate.visibleController.navigationController pushViewController:toVc animated:YES];
    if ([self.delegate respondsToSelector:@selector(cell:clickedIconAtIndexPath:)]) {
        [self.delegate cell:self clickedIconAtIndexPath:self.indexPath];
    }
}

#pragma mark - 网络
/** rq 关注<作者> */
- (void)requestAddFollowAuthor
{
    NSDictionary *params = @{
                             @"type": @"1",
                             @"id": @(self.userObject.id)
                             };
    [GMNetworking requestOCWithApi:API_V1_FOLLOW method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
    }];
}

/** rq 取消关注<作者> */
- (void)requestCancelFollowAuthor
{
    NSDictionary *params = @{
                             @"type": @"1",
                             @"id": @(self.userObject.id)
                             };
    [GMNetworking requestOCWithApi:API_V1_CANCEL_FOLLOW method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
    }];
}

@end
