//
//  ALRecommendUserView.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALRecommendUserView.h"
#import "ALRecommendFollowUserCell.h"
#import "ALTopicCardObject.h"

@interface ALRecommendUserView()<UICollectionViewDelegate, UICollectionViewDataSource, ALRecommendFollowUserCellDelegate>
@property (nonatomic, strong) GMLabel *recommendTitleLabel;
@property (nonatomic, strong) GMCollectionView *collection;
@end

static CGFloat kItemHeight;

@implementation ALRecommendUserView
- (void)setup {
    [super setup];
    self.recommendUserArray = @[];
    
    self.backgroundColor = UIColor.background;
    // 248
    // 标题
    GMLabel *recommendTitleLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:18];
    recommendTitleLabel.frame = CGRectMake(15, 0, MAINSCREEN_WIDTH - 30, 42);
    recommendTitleLabel.text = @"推荐关注";
    recommendTitleLabel.font = [UIFont gmBoldFont:18];
    [self addSubview:recommendTitleLabel];
    self.recommendTitleLabel = recommendTitleLabel;
    [_recommendTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
        make.top.mas_equalTo(0);
        make.height.mas_equalTo(42);
    }];
    
    // 添加推荐关注人列表（103）
    UICollectionViewFlowLayout *layout = [UICollectionViewFlowLayout new];
    CGFloat itemWidth = kItemWidth;
    CGFloat itemHeight = ceilf((kItemWidth * 190) / 140);
    layout.itemSize = CGSizeMake(itemWidth, itemHeight);
    layout.minimumInteritemSpacing = 10;
    layout.minimumLineSpacing =  10;
    layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    
    _collection = [[GMCollectionView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH - 30, 190) collectionViewLayout:layout];
    [self addSubview:_collection];
    _collection.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    _collection.showsHorizontalScrollIndicator = NO;
    _collection.dataSource = self;
    _collection.delegate = self;
    _collection.allowsSelection = YES;
    _collection.allowsMultipleSelection = NO;
    _collection.contentInset = UIEdgeInsetsMake(0, 15, 0, 15);
    _collection.backgroundColor = [UIColor clearColor];
    [_collection registerCell:[ALRecommendFollowUserCell class]];
    [_collection mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.height.mas_equalTo(itemHeight);
        make.bottom.mas_equalTo(-16);
    }];
    
    _recommendUserViewHeight = itemHeight + 42 + 16;
    kItemHeight = _recommendUserViewHeight;
}

+ (CGFloat)recommendUserViewHeight
{
    return kItemHeight;
}

- (void)setRecommendUserArray:(NSArray *)recommendUserArray {
    _recommendUserArray = recommendUserArray;
    [self.collection reloadData];
}

#pragma mark - UICollectionViewDataSource
- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView {
    return 1;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.recommendUserArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    
    ALRecommendFollowUserCell *cell = [collectionView dequeueCell:[ALRecommendFollowUserCell class] forIndexPath:indexPath];
    cell.indexPath = indexPath;
    cell.delegate = self;
    ALTopicCardRecommentObject *userObj = self.recommendUserArray[indexPath.row];
    cell.userObject = userObj;
    return cell;
}

#pragma mark - UICollectionViewDelegate
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    
    // 跳转查看用户详情 (内部直接跳转)
//    ALRecommendUserObject *userObject = self.recommendUserArray[indexPath.row];
    /*
    if (self.didClickFollowUserDetailBlock) {
        self.didClickFollowUserDetailBlock();
    }*/
}

#pragma mark - ALRecommendFollowUserCellDelegate
- (void)cell:(ALRecommendFollowUserCell *)view clickedIconAtIndexPath:(NSIndexPath *)indexPath {
    if ([self.delegate respondsToSelector:@selector(recommendView:clickedIconAtIndexPath:)]) {
        [self.delegate recommendView:self clickedIconAtIndexPath:indexPath];
    }
}

/**
 触发了关注事件
 
 @param view self
 @param indexPath indexPath
 @param voteString 取值(@"do", @"undo"), do:关注, undo:取消关注
 */
- (void)cell:(ALRecommendFollowUserCell *)view clickedFollowAtIndexPath:(NSIndexPath *)indexPath voteString:(NSString *)voteString {
    if ([self.delegate respondsToSelector:@selector(recommendView:clickedFollowAtIndexPath:voteString:)]) {
        [self.delegate recommendView:self clickedFollowAtIndexPath:indexPath voteString:voteString];
    }
}
@end
