//
//  GMPlayerControlView.m
//  Gengmei
//
//  Created by 朱璇 on 2018/9/4.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMPlayerControlView.h"

@implementation GMPlayerControlView
- (instancetype)init {
    if (self == [super init]) {
        _bigPlayerBtn = [[GMButton alloc] init];
        _bigPlayerBtn.hidden = YES;
        [_bigPlayerBtn setImage:[UIImage imageNamed:@"diary_video_cover"] forState:UIControlStateNormal];
        [_bigPlayerBtn addTarget:self action:@selector(playVideo:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_bigPlayerBtn];
        
        _coverView = [GMView new];
        _coverView.hidden = YES;
        _coverView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:.4];
        [self addSubview:_coverView];
        [self sendSubviewToBack:_coverView];
        
        [_bigPlayerBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.equalTo(self);
            make.width.mas_equalTo(MAINSCREEN_WIDTH - 100);
            make.height.mas_equalTo(MAINSCREEN_HEIGHT - 300);
        }];
        [_coverView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self);
        }];
    }
    return self;
}
// 播放
-(void)playVideo:(GMButton *)sender {
    if ([self.touchDelegate respondsToSelector:@selector(didClickPlayerBtn:)]) {
        [self.touchDelegate didClickPlayerBtn:sender];
    }
}

//触摸开始
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [super touchesBegan:touches withEvent:event];
    //获取触摸开始的坐标
    UITouch *touch = [touches anyObject];
    CGPoint currentP = [touch locationInView:self];
    [self.touchDelegate touchesBeganWithPoint:currentP];
}

//触摸结束
- (void)touchesEnded:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [super touchesEnded:touches withEvent:event];
    UITouch *touch = [touches anyObject];
    CGPoint currentP = [touch locationInView:self];
    [self.touchDelegate touchesEndWithPoint:currentP];
}

//移动
- (void)touchesMoved:(NSSet<UITouch *> *)touches withEvent:(nullable UIEvent *)event {
    UITouch *touch = [touches anyObject];
    CGPoint currentP = [touch locationInView:self];
    [self.touchDelegate touchesMoveWithPoint:currentP];
}
@end
