//
//  GMPlayerView.h
//  Gengmei
//
//  Created by 翟国钧 on 2016/12/13.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import <AVFoundation/AVFoundation.h>

#import <AVFoundation/AVFoundation.h>
#import "GMVideoObject.h"

typedef NS_ENUM(NSUInteger, TouchDirection) {
    TouchDirectionLeftOrRight,
    TouchDirectionUpOrDown,
    TouchDirectionNone
};

// class: 音量、亮度
@interface GMPlayerVolumeAndBrightView : GMView
@property (nonatomic, strong) UIProgressView *progressView;
-(instancetype)initWithFrame:(CGRect)frame title:(NSString *)title image:(UIImage *)image;
@end

// class: 快进、快退
@interface GMPlayerFastSpeedView : GMView
@property (nonatomic, strong) UILabel *timeLabel;
@property (nonatomic, strong) GMImageView *imageView;
@end

NS_ASSUME_NONNULL_BEGIN
@interface GMPlayerView : UIView

/**
 被播放的video。
 */
@property (nonatomic, strong, nullable) GMVideoObject *video;

/**
 被播放的topic id。
 如果不需要记录播放次数，请使用initNoTopicId初始化GMPlayerView。另外可以参考 addViewNumber 方法
 */
@property (nonatomic, copy, nullable) NSString *topicId;

/**
 播放的页面来源。
 如果不需要记录播放次数，请使用initNoTopicId初始化GMPlayerView。另外可以参考 addViewNumber 方法
 */
@property (nonatomic, copy, nullable) NSString *from;

@property (nonatomic, copy, nullable) void (^closePlayBack)(void);


- (instancetype)init;

/**
 如果不需要记录播放次数，请使用initNoTopicId初始化GMPlayerView。另外可以参考 addViewNumber 方法
 */
- (instancetype)initNoTopicId;

/**
 播放视频，并按照指定rect位置开始动画。如果无法给出rect，就传递CGRectZero
 */
- (void)play:(NSString *)url animationRect:(CGRect)rect;

// 卡片上自动播放视频的时候用这个方法
- (void)play:(NSString *)videoUrl backView:(UIView *)backView;

- (void)stop;

@end
NS_ASSUME_NONNULL_END
