//
//  GMVIdeoBottomVIew.m
//  Gengmei
//
//  Created by Terminator on 2016/11/18.
//  Copyright © 2016年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMVideoBottomView.h"

@implementation GMVideoBottomView

- (void)setup {
    [super setup];
    
    _backgroundView = [[GMImageView alloc] initWithImage:[UIImage imageNamed:@"player_bottomBackview"]];
    _backgroundView.userInteractionEnabled = YES;
    [self addSubview:_backgroundView];
    
    _playButton = [GMButton buttonWithType:UIButtonTypeCustom];
    [_playButton setBackgroundColor:[UIColor clearColor] forState:UIControlStateNormal];
    [_playButton setImage:[UIImage imageNamed:@"player"] forState:UIControlStateSelected];
    [_playButton setImage:[UIImage imageNamed:@"pause"] forState:UIControlStateNormal];
    [_backgroundView addSubview:_playButton];
    
    _playerTime = [[GMLabel alloc] init];
    _playerTime.font = [UIFont gmFont:11];
    _playerTime.textColor = [UIColor whiteColor];
    _playerTime.textAlignment = NSTextAlignmentCenter;
    _playerTime.text = [NSString stringWithFormat:@"00:00"];
    [_backgroundView addSubview:_playerTime];
    
    _processSlider = [[UISlider alloc] init];
    [_processSlider setThumbImage:[UIImage imageNamed:@"current_slider"] forState:UIControlStateNormal];
    _processSlider.maximumTrackTintColor = [RGBCOLOR_HEX(0xffffff) colorWithAlphaComponent:0.6];
    _processSlider.minimumTrackTintColor = [UIColor whiteColor];
    [_backgroundView addSubview:_processSlider];
    
    _totalTime = [[GMLabel alloc] init];
    _totalTime.font = [UIFont gmFont:11];
    _totalTime.textColor = [UIColor whiteColor];
    _totalTime.text = [NSString stringWithFormat:@"00:00"];
    _totalTime.textAlignment = NSTextAlignmentCenter;
    [_backgroundView addSubview:_totalTime];
    
    self.enterFullScreenButton = [GMButton buttonWithType:UIButtonTypeCustom];
    [self.enterFullScreenButton setImage:[UIImage imageNamed:@"player_fullScreen"] forState:(UIControlStateNormal)];
    [self.enterFullScreenButton addTarget:self action:@selector(clickEnterFullScreenButton) forControlEvents:(UIControlEventTouchUpInside)];
    [_backgroundView addSubview:self.enterFullScreenButton];
    
    self.exitfullScreenButton = [GMButton buttonWithType:UIButtonTypeCustom];
    [self.exitfullScreenButton setImage:[UIImage imageNamed:@"player_exitFullScreen"] forState:(UIControlStateNormal)];
    [self.exitfullScreenButton addTarget:self action:@selector(clickExitFullScreenButton) forControlEvents:(UIControlEventTouchUpInside)];
    [_backgroundView addSubview:self.exitfullScreenButton];
    
    [_backgroundView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
    [_playButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(12);
        make.centerY.mas_equalTo(_backgroundView.mas_centerY);
        make.height.equalTo(_backgroundView);
        make.width.mas_equalTo(30);
    }];
    [_playerTime mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_backgroundView.mas_centerY);
        make.width.mas_equalTo(32);
        make.left.equalTo(self.playButton.mas_right).offset(0);
    }];
    [_processSlider mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_playerTime.mas_right).offset(8);
        make.height.mas_equalTo(_backgroundView.mas_height);
        make.centerY.mas_equalTo(_backgroundView.mas_centerY);
    }];
    [_totalTime mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_backgroundView.mas_centerY);
        make.width.mas_equalTo(32);
        make.left.equalTo(_processSlider.mas_right).offset(8);
    }];
    [_enterFullScreenButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-14);
        make.centerY.mas_equalTo(_backgroundView.mas_centerY);
        make.left.equalTo(_totalTime.mas_right).offset(2);
        make.height.equalTo(_backgroundView);
        make.width.mas_equalTo(30);
    }];
}

- (void)enterFullScreen:(BOOL)isFull {
    if (isFull) {
        [_playButton mas_remakeConstraints:^(MASConstraintMaker *make) {
            if ([UIDevice resolutionType] == iPhone58Inches) {
                make.left.mas_equalTo(12 + OCNavigationBar.statusBarHeight);
            } else {
                make.left.mas_equalTo(12);
            }
            make.centerY.mas_equalTo(_backgroundView.mas_centerY);
            make.height.equalTo(_backgroundView);
            make.width.mas_equalTo(30);
        }];
        [_enterFullScreenButton mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(0);
            make.height.mas_equalTo(0);
        }];
        [_exitfullScreenButton mas_remakeConstraints:^(MASConstraintMaker *make) {
            if ([UIDevice resolutionType] == iPhone58Inches) {
                make.right.mas_equalTo(-14 - OCNavigationBar.statusBarHeight);
            } else {
                make.right.mas_equalTo(-14);
            }
            make.centerY.mas_equalTo(_backgroundView.mas_centerY);
            make.left.equalTo(_totalTime.mas_right).offset(2);
            make.height.equalTo(self);
            make.width.mas_equalTo(30);
        }];
    } else {// 竖屏状态
        [_playButton mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(12);
            make.centerY.mas_equalTo(_backgroundView.mas_centerY);
            make.height.equalTo(_backgroundView);
            make.width.mas_equalTo(30);
        }];
        [_enterFullScreenButton mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(-14);
            make.centerY.mas_equalTo(_backgroundView.mas_centerY);
            make.left.equalTo(_totalTime.mas_right).offset(2);
            make.height.equalTo(self);
            make.width.mas_equalTo(30);
        }];
        [_exitfullScreenButton mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(0);
            make.height.mas_equalTo(0);
        }];
    }
}

- (void)clickEnterFullScreenButton {
    if ([self.delegate respondsToSelector:@selector(didClickEnterFullScreen)]) {
        [self.delegate didClickEnterFullScreen];
    }
}
- (void)clickExitFullScreenButton {
    if ([self.delegate respondsToSelector:@selector(didClickExitFullScreen)]) {
        [self.delegate didClickExitFullScreen];
    }
}
@end
