//
//  UIViewController+VideoPlayer.m
//  Gengmei
//
//  Created by wangyang on 2017/1/6.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "UIViewController+VideoPlayer.h"
#import <objc/runtime.h>
@import AFNetworking;
@interface UIViewController ()

@end
@implementation UIViewController (VideoPlayer)

- (NSString *(^)(void))videoPlayViewFrom {
    return objc_getAssociatedObject(self, _cmd);
}

- (void)setVideoPlayViewFrom:(NSString *(^)(void))videoPlayViewFrom {
    objc_setAssociatedObject(self, @selector(videoPlayViewFrom), videoPlayViewFrom, OBJC_ASSOCIATION_COPY);
}

- (NSString *)tagId {
    return objc_getAssociatedObject(self, _cmd);
}

- (void)setTagId:(NSString *)tagId {
    objc_setAssociatedObject(self, @selector(tagId), tagId, OBJC_ASSOCIATION_COPY);
}
- (NSString *)tabName {
    return objc_getAssociatedObject(self, _cmd);
}

- (void)setTabName:(NSString *)tabName {
    objc_setAssociatedObject(self, @selector(tabName), tabName, OBJC_ASSOCIATION_COPY);
}

- (BOOL)isFullScreen {
    return [objc_getAssociatedObject(self, _cmd) boolValue];
}

- (void)setIsFullScreen:(BOOL)isFullScreen {
    objc_setAssociatedObject(self, @selector(isFullScreen), @(isFullScreen), OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (GMPlayerView *)player {
    GMPlayerView *_player = objc_getAssociatedObject(self, @selector(player));
    if (_player == nil) {
        _player = [GMPlayerView new];
        objc_setAssociatedObject(self, @selector(player), _player, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
    }
    return  _player;
}

- (void)setPlayer:(GMPlayerView *)player {
    objc_setAssociatedObject(self, @selector(player), player, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

- (void)playVideo:(GMVideoObject *)video animationStartRect:(CGRect)rect {
    if ([AFNetworkReachabilityManager sharedManager].networkReachabilityStatus == AFNetworkReachabilityStatusNotReachable) {
        [self toast:@"网络情况欠佳，请检查网络"];
        return;
    }
    __weak __typeof(self)weakSelf = self;
    self.player = [GMPlayerView new];
    self.player.closePlayBack = ^{
        weakSelf.player = nil;
    };
    
    video.pageName = AppDelegate.visibleController.pageName;
    video.tabName = self.tabName;
    video.tagId = self.tagId;
    
    self.player.video = video;
    
    self.player.topicId = video.topicId;
//    self.player.from = self.videoPlayViewFrom();
    
    
    [self.player play:self.player.video.videoUrl animationRect:rect];
}
@end
