//
//  ALGroupDetailController.m
//  GMAlpha
//
//  Created by zhb on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupDetailController.h"
#import "ALGroupTopicCell.h"
#import "ALGroupTestObject.h"
#import "ALGroupPostView.h"

#import "ALTopicDetailController.h"
#import "ALTopicCommentListView.h"


@interface ALGroupDetailController ()<ALGroupTopicCellDelegate>
@property (nonatomic, strong) NSMutableArray *testArray;
@property (nonatomic, strong) ALGroupPostView *postView;
@end

@implementation ALGroupDetailController
@synthesize viewModel;

#pragma mark -- life cycle
- (void)initController{
    [super initController];
    self.heightCacheByIndexPath = YES;
    self.immediateLoad = NO;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.testArray = [NSMutableArray array];
    for (int i = 0; i < 5; i++) {
        ALGroupTestObject *obj = [ALGroupTestObject new];
        [self.testArray addObject:obj];
    }
    [self.view addSubview:self.postView];
    [self.postView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.mas_equalTo(0);
        make.height.mas_equalTo(44);
    }];
    
    [self.table mas_updateConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-44);
    }];
    
    [self.table registerClass:[ALGroupTopicCell class] forCellReuseIdentifier:NSStringFromClass([ALGroupTopicCell class])];
}

#pragma mark -- system dataSource and delegate
-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    //返回行数
    return self.testArray.count;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    NSString *reusableId = [self cellIdentifierAtIndexPath:indexPath];
    ALGroupTopicCell *cell = [tableView dequeueReusableCellWithIdentifier:reusableId forIndexPath:indexPath];
    cell.indexPath = indexPath;
    cell.delegate = self;
    ALGroupTestObject *obj = self.testArray[indexPath.row];
    cell.obj = obj;
    [self configDataForCell:cell atIndexPath:indexPath];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    
}




//- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
//    return UITableViewAutomaticDimension;
//}

- (CGFloat)tableView:(UITableView *)tableView estimatedHeightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    __weak __typeof(self)weakSelf = self;
    if (self.heightCacheByIndexPath) {
        CGFloat height = [_table fd_heightForCellWithIdentifier:[self cellIdentifierAtIndexPath:indexPath] cacheByIndexPath:indexPath configuration:^(id cell) {
            [weakSelf configDataForCell:cell atIndexPath:indexPath];
        }];
        return height;
    } else {
        NSString *key = [self cellIdentifierAtIndexPath:indexPath];
        CGFloat height = [_table fd_heightForCellWithIdentifier:[self cellIdentifierAtIndexPath:indexPath] cacheByKey:key configuration:^(GMTableViewCell *cell) {
            [weakSelf configDataForCell:cell atIndexPath:indexPath];
        }];
        return height;
    }
}

#pragma mark -- custom dataSource and delegate


- (void)groupTopicCell:(ALGroupTopicCell *)cell clickedFollowButton:(UIButton *)button {
    [self.table reloadRowsAtIndexPaths:@[cell.indexPath] withRowAnimation:UITableViewRowAnimationNone];
    [self.table setNeedsUpdateConstraints];
}


#pragma mark -- event response
- (void)clickPostView:(UITapGestureRecognizer *)tapGst {
    ALTopicCommentListView *toVc = [[ALTopicCommentListView alloc] init];
    [self.view addSubview:toVc];

//    [self pushViewController:toVc];
}

#pragma mark -- network

#pragma mark -- private methods

- (NSString *)cellIdentifierAtIndexPath:(NSIndexPath *)indexPath {
    return NSStringFromClass([ALGroupTopicCell class]);
}

- (void)configDataForCell:(id)cell atIndexPath:(NSIndexPath *)indexPath {
    
}

#pragma mark -- getters and setters

- (ALGroupPostView *)postView {
    if (_postView == nil) {
        _postView = [[ALGroupPostView alloc] initWithImageName:@"" placeholdString:@""];
        UITapGestureRecognizer *tapGst = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(clickPostView:)];
        tapGst.numberOfTapsRequired = 1;
        [_postView addGestureRecognizer:tapGst];
    }
    return _postView;
}



@end
