//
//  ALGroupDetailObject.h
//  GMAlpha
//
//  Created by zhb on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALTopicCardObject.h"

//data.star
@protocol ALGroupDetailStarObject @end
@interface ALGroupDetailStarObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *desc;
@property (nonatomic, copy) NSString *icon;
@property (nonatomic, copy) NSString *pickDesc;
@property (nonatomic, copy) NSString *pickId;
@property (nonatomic, copy) NSString *pickUserId;
@property (nonatomic, copy) NSString *url;
@end

//data.user_info ???
@protocol ALGroupDetailUserInfoObject @end
@interface ALGroupDetailUserInfoObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *userName;
@property (nonatomic, copy) NSString *icon;
@end

// data.group.creator
@protocol ALGroupDetailCreatorObject @end
@interface ALGroupDetailCreatorObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *icon;
@end

// data.group
@protocol ALGroupDetailGroupObject @end
@interface ALGroupDetailGroupObject : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *desc;
@property (nonatomic, copy) NSString *icon;
@property (nonatomic, assign) NSInteger topicNum;
@property (nonatomic, assign) BOOL isFollow;
@property (nonatomic, assign) NSArray *starArray;
@property (nonatomic, assign) NSInteger userNums;
@property (nonatomic, copy) NSString *createTime;
@property (nonatomic, assign) BOOL isDesc;
@property (nonatomic, strong) ALGroupDetailCreatorObject *creator;
/** 是否关闭了频道简介 */
@property (nonatomic, assign) BOOL isHiddenVerb;

@end

@interface ALGroupDetailObject : GMObject
@property (nonatomic, strong) ALGroupDetailGroupObject *group;
@property (nonatomic, strong) ALGroupDetailUserInfoObject *userInfo;
@property (nonatomic, strong) ALGroupDetailStarObject *celebrity;
@property (nonatomic, strong) NSArray<ALTopicCardObject> *topics;
@end
