//
//  ALGroupDetailNavigationView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/12.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupDetailNavigationView.h"

@interface ALGroupDetailNavigationView ()
@property (nonatomic, strong) UIButton *backButton;
@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, strong) UIButton *followButton;
@property (nonatomic, strong) UIButton *inviteButton;

@end

@implementation ALGroupDetailNavigationView

- (void)setGroupObj:(ALGroupDetailGroupObject *)groupObj {
    if (groupObj == nil) return;
    _groupObj = groupObj;
    self.titleLabel.text = groupObj.name;
    self.followButton.hidden = groupObj.isFollow;
    self.inviteButton.hidden = NO;
}
- (void)hiddenFollowButton {
    self.followButton.hidden = YES;
}
#pragma mark - life cycle
- (void)setup {
    [super setup];
    self.backgroundColor = UIColor.whiteColor;
    [self addSubview:self.backButton];
    [self addSubview:self.titleLabel];
    [self addSubview:self.followButton];
    [self addSubview:self.inviteButton];
    [self addSubViewConstraints];
}

- (void)addSubViewConstraints {
    [self.backButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(20);
        make.left.bottom.equalTo(self);
        make.width.mas_equalTo(42);
    }];
    
    [self.inviteButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(20);
        make.bottom.equalTo(self);
        make.right.equalTo(self).offset(-15);
    }];
    
    [self.followButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(20);
        make.bottom.equalTo(self);
        make.right.equalTo(self.inviteButton.mas_left).offset(-20);
    }];
    
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(20);
        make.bottom.equalTo(self);
        make.left.equalTo(self.backButton.mas_right);
        make.right.equalTo(self.followButton.mas_left).offset(-50);
    }];
}

#pragma mark - event
// action : 返回
-(void)clickedBackButton {
    if ([self.delegate respondsToSelector:@selector(navigationView:clickedBackButton:)]) {
        [self.delegate navigationView:self clickedBackButton:self.backButton];
    }
}

// action : 关注小组
- (void)clickedFollowButton:(UIButton *)sender {
    if ([self.delegate respondsToSelector:@selector(navigationView:clickedFollowButton:)]) {
        [self.delegate navigationView:self clickedFollowButton:self.backButton];
    }
}

// action : 邀请
- (void)clickedInviteButton:(UIButton *)sender {
    if ([self.delegate respondsToSelector:@selector(navigationView:clickedInviteButton:)]) {
        [self.delegate navigationView:self clickedInviteButton:self.backButton];
    }
}

#pragma mark - getters and setters
- (UIButton *)backButton
{
    if (_backButton == nil) {
        _backButton = [[UIButton alloc] init];
        [_backButton setImage:[UIImage imageNamed:@"nav_back"] forState:UIControlStateNormal];
        [_backButton addTarget:self action:@selector(clickedBackButton) forControlEvents:UIControlEventTouchUpInside];
    }
    return _backButton;
}

- (UILabel *)titleLabel
{
    if (_titleLabel == nil) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.textColor = RGBCOLOR_HEX(0x282828);
        _titleLabel.font = [UIFont gmBoldFont:18];
        _titleLabel.numberOfLines = 2;
    }
    return _titleLabel;
}

- (UIButton *)followButton
{
    if (_followButton == nil) {
        _followButton = [[UIButton alloc] init];
        UIColor *color = [UIColor colorWithHexString:@"0093FF"];
        [_followButton setTitleColor:color forState:UIControlStateNormal];
        _followButton.titleLabel.font = [UIFont gmFont:16];
        [_followButton setTitle:@"关注" forState:UIControlStateNormal];
        [_followButton addTarget:self action:@selector(clickedFollowButton:) forControlEvents:UIControlEventTouchUpInside];
        [_followButton setContentHuggingPriority:300 forAxis:UILayoutConstraintAxisHorizontal];
        [_followButton setContentCompressionResistancePriority:800 forAxis:UILayoutConstraintAxisHorizontal];
        _followButton.hidden = YES;
    }
    return _followButton;
}

- (UIButton *)inviteButton
{
    if (_inviteButton == nil) {
        _inviteButton = [[UIButton alloc] init];
        [_inviteButton setImage:[UIImage imageNamed:@"group_invite"] forState:UIControlStateNormal];
        UIColor *color = [UIColor colorWithHexString:@"0093FF"];
        [_inviteButton setTitleColor:color forState:UIControlStateNormal];
        _inviteButton.titleLabel.font = [UIFont gmFont:16];
        [_inviteButton setTitle:@"邀请" forState:UIControlStateNormal];
        [_inviteButton addTarget:self action:@selector(clickedInviteButton:) forControlEvents:UIControlEventTouchUpInside];
        [_inviteButton setContentHuggingPriority:300 forAxis:UILayoutConstraintAxisHorizontal];
        [_inviteButton setContentCompressionResistancePriority:800 forAxis:UILayoutConstraintAxisHorizontal];
        _inviteButton.hidden = YES;
    }
    return _inviteButton;
}

@end
