//
//  ALGroupListTopView.m
//  GMAlpha
//
//  Created by ioszhb on 2018/12/8.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupListTopView.h"

@interface ALGroupListTopView()
/** 上部白色view */
@property (nonatomic, strong) UIView *topBkView;
/** 频道简介Lb */
@property (nonatomic, strong) UILabel *titleLb;
/** 简介内容Lb */
@property (nonatomic, strong) UILabel *descLb;
/** 关闭button */
@property (nonatomic, strong) GMButton *closeBtn;

/** 下部灰色view */
@property (nonatomic, strong) UIView *bottomBkView;
/** 明星白色框View */
@property (nonatomic, strong) UIView *starBkView;
/** 明星头像V */
@property (nonatomic, strong) UIImageView *starIconV;
/** 明星nameLb*/
@property (nonatomic, strong) UILabel *starNameLb;
/** 明星介绍 */
@property (nonatomic, strong) UILabel *starDescLb;
/** 明星arrowbutton */
@property (nonatomic, strong) UIButton *starArrowBtn;

@property (nonatomic, assign) CGFloat myHeight;
@property (nonatomic, strong) NSDictionary *descAttributes;
@end

@implementation ALGroupListTopView
- (void)setDataObj:(ALGroupDetailObject *)dataObj {
    _dataObj = dataObj;
    //1.必须先设置数据
    NSString *descString = dataObj.group.desc ? : @"";
    if (descString.length == 0) {
        self.descLb.attributedText = nil;
    }else {
        self.descLb.attributedText = [[NSAttributedString alloc] initWithString:descString attributes:self.descAttributes];
    }
    NSURL *starIcon = [NSURL URLWithString:dataObj.celebrity.icon];
    [self.starIconV sd_setImageWithURL:starIcon placeholderImage:[self defaultStarIcon]];
    self.starNameLb.text = dataObj.celebrity.name;
    self.starDescLb.text = dataObj.celebrity.pickDesc;
    NSString *url = dataObj.celebrity.url;
    self.starArrowBtn.hidden =  !([url isNonEmpty]);
    //2.再更新状态
    [self updateLayouts];
}

- (void)setup {
    [super setup];
    self.clipsToBounds = YES;
    self.backgroundColor = UIColor.background;
    
    [self addSubview:self.topBkView];
    [self.topBkView addSubview:self.descLb];
    [self.topBkView addSubview:self.titleLb];
    [self.topBkView addSubview:self.closeBtn];
    
    [self addSubview:self.bottomBkView];
    [self.bottomBkView addSubview:self.starBkView];
    [self.starBkView addSubview:self.starIconV];
    [self.starBkView addSubview:self.starNameLb];
    [self.starBkView addSubview:self.starDescLb];
    [self.starBkView addSubview:self.starArrowBtn];

    [self.topBkView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.equalTo(self).offset(0);
        make.bottom.equalTo(self).offset(-10).priority(900);
    }];
    [self.descLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.topBkView).insets(UIEdgeInsetsMake(50, 15, 20, 15));
    }];
    [self.titleLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.descLb);
        make.bottom.equalTo(self.descLb.mas_top).offset(-8);
    }];
    
    
    [self.closeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(24, 24));
        make.top.mas_equalTo(10).priority(800);
        make.right.mas_equalTo(-15);
    }];

    [self.bottomBkView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.topBkView.mas_bottom).offset(0);
        make.top.equalTo(self).offset(-10).priority(900);
        make.bottom.equalTo(self.mas_bottom).offset(0);
        make.left.equalTo(self).offset(0);
        make.right.equalTo(self).offset(0);
        make.height.mas_equalTo(95);
    }];
    [self.starBkView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.insets(UIEdgeInsetsMake(10, 0, 10, 0));
    }];
    
    [self.starIconV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(45, 45));
        make.left.mas_equalTo(15);
        make.centerY.mas_equalTo(0);
    }];
    [self.starNameLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.starBkView.mas_centerY).offset(-1.5);
        make.left.equalTo(self.starIconV.mas_right).offset(10);
        make.right.mas_lessThanOrEqualTo(-40);
    }];
    [self.starDescLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.starBkView.mas_centerY).offset(1.5);
        make.left.equalTo(self.starNameLb);
        make.right.mas_lessThanOrEqualTo(-40);
    }];
    [self.starArrowBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.mas_equalTo(0);
        make.right.mas_equalTo(-15);
        make.width.mas_equalTo(10);
    }];
}

/** action : 关闭简介❌ */
- (void)clickedCloseButton:(UIButton *)sender {
    //1.用户登录权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    //2.更改数据
    self.dataObj.group.isDesc = NO;
    [self updateLayouts];
    //3.网络请求
    [self requestCloseGroupDesc];
    
    if ([self.delegate respondsToSelector:@selector(groupTopView: clickedCloseButton:)]) {
        [self.delegate groupTopView:self clickedCloseButton:sender];
    }
}

/** action : 点击明星 */
- (void)clickedStarView:(UIButton *)sender {
    if ([self.delegate respondsToSelector:@selector(groupTopView: clickedStarView:)]) {
        [self.delegate groupTopView:self clickedStarView:self.starBkView];
    }
}

#pragma mark - 私有方法
/** 关闭小组简介--请求 */
- (void)requestCloseGroupDesc {
    NSDictionary *params = @{
                             @"group_id": @(self.dataObj.group.id)
                             };
    [GMNetworking requestOCWithApi:API_V1_GROUP_USER_DELETE_DESC method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
    }];
}

- (void)updateLayouts {
    //是否隐藏简介
    BOOL isHiddenVerb = !(_dataObj.group.isDesc);
    BOOL isHiddenStar = (_dataObj.celebrity.icon == nil);
    if (_dataObj == nil) {
        isHiddenVerb = YES;
        isHiddenStar = YES;
    }
    //1.设置数据
    //2.状态
    self.topBkView.hidden = isHiddenVerb;
    self.bottomBkView.hidden = isHiddenStar;
    
    if (isHiddenVerb) {
        [self.topBkView removeFromSuperview];
    }
    if (isHiddenStar) {
        [self.bottomBkView removeFromSuperview];
    }

    //计算总高度
    if (isHiddenStar && isHiddenVerb) {
        [self mas_updateConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(0.1);
        }];
    }
    [self layoutIfNeeded];
    CGFloat currentHeight = self.frame.size.height;
    if ([self.delegate respondsToSelector:@selector(groupTopView:changeHeight:)]) {
        [self.delegate groupTopView:self changeHeight:currentHeight];
    }
//    if (self.myHeight != currentHeight) {
//        self.myHeight = currentHeight;
//    }
}

#pragma mark - getter Views
- (UIView *)topBkView {
    if (!_topBkView) {
        _topBkView = [[UIView alloc] init];
        _topBkView.backgroundColor = UIColor.whiteColor;
    }
    return _topBkView;
}

- (UILabel *)descLb {
    if (_descLb == nil) {
        _descLb = [[UILabel alloc] init];
        _descLb.textColor = UIColor.auxiliaryTextLight;
        _descLb.font = [UIFont gmFont:14];
        _descLb.numberOfLines = 0;
        [_descLb setContentHuggingPriority:1000 forAxis:0];
        [_descLb setContentHuggingPriority:1000 forAxis:1];
        [_descLb setContentCompressionResistancePriority:1000 forAxis:0];
        [_descLb setContentCompressionResistancePriority:1000 forAxis:1];
        [_descLb sizeToFit];
    }
    return _descLb;
}

- (UILabel *)titleLb {
    if (_titleLb == nil) {
        _titleLb = [[UILabel alloc] init];
        _titleLb.textColor = UIColor.auxiliaryTextLight;
        _titleLb.font = [UIFont gmFont:14];
        _titleLb.numberOfLines = 0;
        _titleLb.text = @"小组信息:";
        [_titleLb setContentHuggingPriority:1000 forAxis:0];
        [_titleLb setContentHuggingPriority:1000 forAxis:1];
        [_titleLb setContentCompressionResistancePriority:1000 forAxis:0];
        [_titleLb setContentCompressionResistancePriority:1000 forAxis:1];
        [_titleLb sizeToFit];
    }
    return _titleLb;
}

- (GMButton *)closeBtn {
    if (_closeBtn == nil) {
        _closeBtn = [[GMButton alloc] init];
        _closeBtn.enableAdaptive = YES;
        [_closeBtn setImage:[UIImage imageNamed:@"group_cross"] forState:UIControlStateNormal];
        [_closeBtn addTarget:self action:@selector(clickedCloseButton:) forControlEvents:UIControlEventTouchDown];
    }
    return _closeBtn;
}

///////////////
- (UIView *)bottomBkView {
    if (!_bottomBkView) {
        _bottomBkView = [[UIView alloc] init];
        _bottomBkView.backgroundColor = UIColor.background;
    }
    return _bottomBkView;
}

- (UIView *)starBkView {
    if (!_starBkView) {
        _starBkView = [[UIView alloc] init];
        _starBkView.backgroundColor = UIColor.whiteColor;
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedStarView:)];
        [_starBkView addGestureRecognizer:tap];
    }
    return _starBkView;
}

- (UIButton *)starArrowBtn {
    if (!_starArrowBtn) {
        _starArrowBtn = [[UIButton alloc] init];
        [_starArrowBtn setImage:[UIImage imageNamed:@"group_right_arrow"] forState:UIControlStateNormal];
    }
    return _starArrowBtn;
}

- (UIImageView *)starIconV {
    if (!_starIconV) {
        _starIconV = [[UIImageView alloc] init];
        _starIconV.image = [UIImage imageNamed:@"user_setter_default_icon_new"];
        _starIconV.layer.cornerRadius = 45 * 0.5;
        _starIconV.clipsToBounds = YES;
    }
    return _starIconV;
}

- (UILabel *)starNameLb {
    if (!_starNameLb) {
        _starNameLb = [[UILabel alloc] init];
        _starNameLb.textColor = UIColor.headlineText;
        _starNameLb.font = [UIFont gmFont:16];
        _starNameLb.text = @"";
    }
    return _starNameLb;
}

- (UILabel *)starDescLb {
    if (!_starDescLb) {
        _starDescLb = [[UILabel alloc] init];
        _starDescLb.textColor = UIColor.auxiliaryTextLight;
        _starDescLb.font = [UIFont gmFont:14];
        _starDescLb.text = @"多多少少所";
    }
    return _starDescLb;
}

- (UIImage *)defaultStarIcon {
    return [UIImage imageNamed:@"user_setter_default_icon_new"];
}

- (NSDictionary *)descAttributes {
    if (!_descAttributes) {
        NSMutableParagraphStyle *paragraphStyle = [NSMutableParagraphStyle new];
        paragraphStyle.lineSpacing = 1.5;// 字体的行间距
        _descAttributes = @{
                            NSFontAttributeName:[UIFont gmFont:14],
                            NSForegroundColorAttributeName : UIColor.auxiliaryTextLight,
                            NSParagraphStyleAttributeName:paragraphStyle
                            };
    }
    return _descAttributes;
}
@end
