//
//  ALGroupMedieView.h
//  GMAlpha
//
//  Created by zhb on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "ALGroupDetailObject.h"
@class ALGroupMedieView, ALGroupMedieCollectionCell;

@protocol ALGroupMedieViewDelegate <NSObject>
/** delegate: 播放视频 */
- (void)medieView:(ALGroupMedieView *)mediaView playVideoAtIndexPath:(NSIndexPath *)indexPath;
@end



@protocol ALGroupMedieCollectionCellDelegate <NSObject>
/** delegate: 播放视频 */
- (void)cell:(ALGroupMedieCollectionCell *)cell playVideoAtIndexPath:(NSIndexPath *)indexPath;
@end
@interface ALGroupMedieCollectionCell: GMCollectionViewCell
@property (nonatomic, strong) NSIndexPath *indexPath;
@property (nonatomic, strong) UIImageView *imageView;
@property (nonatomic, strong) UIButton *playButton;
@property (nonatomic, weak) id<ALGroupMedieCollectionCellDelegate> delegate;

@end


@interface ALGroupMedieView : UIView
@property (nonatomic, strong) NSArray<ALTopicCardImageObject *> *medieArray;
@property (nonatomic, weak) id<ALGroupMedieViewDelegate> delegate;
+ (CGFloat)viewHeight;
@end

