//
//  ALGroupMedieView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupMedieView.h"

@interface ALGroupMedieView()<UICollectionViewDataSource, UICollectionViewDelegate, ALGroupMedieCollectionCellDelegate>
@property (nonatomic, strong) UICollectionViewFlowLayout *flowLayout;
@property (nonatomic, strong) UICollectionView *collectionView;
@property (nonatomic, strong) UILabel *indexLabel;
@property (nonatomic, strong) UIImage *defTopicImage;

@end

@implementation ALGroupMedieView

+ (CGFloat)viewHeight {
    return MAINSCREEN_WIDTH;
}
#pragma mark - life cycle

- (instancetype)init {
    self = [super init];
    if (self){
        self.clipsToBounds = YES;
        self.medieArray = @[];
        [self addSubview:self.collectionView];
        [self addSubview:self.indexLabel];
    }
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    [self addSubViewConstraints];
}

- (void)setMedieArray:(NSArray<ALTopicCardImageObject *> *)medieArray {
    _medieArray = medieArray ? : @[];
    self.collectionView.contentOffset = CGPointZero;
    [self.collectionView reloadData];
    self.indexLabel.text = [NSString stringWithFormat:@"1/%zd", medieArray.count];
    self.indexLabel.hidden = (self.medieArray.count < 1);
}

#pragma mark - UICollectionView 数据源/代理
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    if (self.medieArray == nil) {
        return 0;
    }
    else {
        return self.medieArray.count;
    }
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    ALGroupMedieCollectionCell *itemCell = [collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([ALGroupMedieCollectionCell class]) forIndexPath:indexPath];
    //赋值
    itemCell.indexPath = indexPath;
    itemCell.delegate = self;
    ALTopicCardImageObject *obj = self.medieArray[indexPath.row];
    [itemCell.imageView sd_setImageWithURL:[NSURL URLWithString:obj.imageUrl] placeholderImage:_defTopicImage];
    itemCell.playButton.hidden = ![obj.videoUrl isNonEmpty];
    return itemCell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{

}

- (void)scrollViewDidScroll:(UIScrollView *)scrollView {
    CGFloat sizeWidth = scrollView.contentSize.width;
    CGFloat offsetX = scrollView.contentOffset.x;
    if (offsetX < 0) return;
    if (offsetX > sizeWidth) return;
    NSInteger page = round(offsetX/self.itemWidth) + 1;
    self.indexLabel.text = [NSString stringWithFormat:@"%zd/%zd", page, self.medieArray.count];
}

/** delegate: 播放视频 */
- (void)cell:(ALGroupMedieCollectionCell *)cell playVideoAtIndexPath:(NSIndexPath *)indexPath{
    if ([self.delegate respondsToSelector:@selector(medieView:playVideoAtIndexPath:)]) {
        [self.delegate medieView:self playVideoAtIndexPath:indexPath];
    }
}

#pragma mark - private methods
- (void)addSubViewConstraints {
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.bottom.mas_equalTo(0);
    }];
    [self.indexLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(20);
        make.right.mas_equalTo(-15);
        make.height.mas_equalTo(21);
        make.width.mas_greaterThanOrEqualTo(28);
    }];
}

#pragma mark - getters and setters
- (UICollectionViewFlowLayout *)flowLayout {
    if (_flowLayout == nil) {
        _flowLayout = [[UICollectionViewFlowLayout alloc] init];
        _flowLayout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        _flowLayout.itemSize = CGSizeMake(self.itemWidth, self.itemHeight);
        _flowLayout.sectionInset = UIEdgeInsetsMake(0,0,0,0);
        _flowLayout.minimumLineSpacing = 0;
        _flowLayout.minimumInteritemSpacing = 0;
    }
    return _flowLayout;
}

- (UICollectionView *)collectionView {
    if (_collectionView == nil) {
        _collectionView = [[GMCollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:self.flowLayout];
        _collectionView.backgroundColor = UIColor.whiteColor;
        _collectionView.showsVerticalScrollIndicator = NO;
        _collectionView.showsHorizontalScrollIndicator = NO;
        _collectionView.pagingEnabled = YES;
        [_collectionView registerClass:[ALGroupMedieCollectionCell class] forCellWithReuseIdentifier:NSStringFromClass([ALGroupMedieCollectionCell class])];
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
    }
    return _collectionView;
}

- (UILabel *)indexLabel {
    
    if (_indexLabel == nil) {
        _indexLabel = [[UILabel alloc] init];
        _indexLabel.backgroundColor = [UIColor colorWithWhite:0.5 alpha:1];
//        _indexLabel.backgroundColor = [UIColor redColor];
        _indexLabel.textColor = UIColor.whiteColor;
        _indexLabel.font = [UIFont gmLightFont:11];
        _indexLabel.textAlignment = NSTextAlignmentCenter;
        _indexLabel.layer.cornerRadius = 10;
        _indexLabel.layer.masksToBounds = YES;
    }
    return _indexLabel;
}

- (CGFloat)itemHeight {
    return MAINSCREEN_WIDTH;
}

- (CGFloat)itemWidth {
    return MAINSCREEN_WIDTH;
}

- (UIImage *)defTopicImage {
    if (_defTopicImage == nil) {
        _defTopicImage = [UIImage imageWithColor:RGBCOLOR_HEX(0xF4F3F8)];
    }
    return _defTopicImage;
}

@end






////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////// ALGroupMedieCollectionCell  /////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
@implementation ALGroupMedieCollectionCell
#pragma mark - life cycle
- (void)setup {
    [super setup];
    [self.contentView addSubview:self.imageView];
    [self.contentView addSubview:self.playButton];
    [self addSubViewConstraints];

}

- (void)clickedPlayButton:(UIButton *)sender {
    if ([self.delegate respondsToSelector:@selector(cell:playVideoAtIndexPath:)]) {
        [self.delegate cell:self playVideoAtIndexPath:self.indexPath];
    }
}

#pragma mark - private methods
- (void)addSubViewConstraints {
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.mas_equalTo(0);
    }];
    [self.playButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(60, 60));
        make.center.mas_equalTo(CGPointZero);
    }];
}

#pragma mark - getters and setters
- (UIImageView *)imageView {
    if (_imageView == nil) {
        _imageView = [[UIImageView alloc] init];
        _imageView.image = [UIImage imageWithColor:RGBCOLOR_HEX(0xF4F3F8)];
        _imageView.contentMode = UIViewContentModeScaleToFill;
    }
    return _imageView;
}

- (UIButton *)playButton {
    if (_playButton == nil) {
        _playButton = [[UIButton alloc] init];
        [_playButton setImage:[UIImage imageNamed:@"play_video"] forState:UIControlStateNormal];
        [_playButton addTarget:self action:@selector(clickedPlayButton:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _playButton;
}

- (CGFloat)itemWidth {
    return MAINSCREEN_WIDTH;
}
@end
