//
//  ALGroupPostView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/8.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupPostView.h"

@interface ALGroupPostView ()
@property (nonatomic, strong) UIImageView *imageView;
@property (nonatomic, strong) UILabel *textLabel;
@property (nonatomic, copy) NSString *imageName;
@property (nonatomic, copy) NSString *placeholdString;

@end

@implementation ALGroupPostView

#pragma mark - life cycle
- (instancetype)initWithImageName:(NSString *)imageName placeholdString:(NSString *)placeholdStr {
    self = [super init];
    if (self) {
        self.backgroundColor = UIColor.whiteColor;
        self.layer.shadowColor = [UIColor colorWithWhite:0 alpha:0.2].CGColor;
        self.layer.shadowOffset = CGSizeMake(0, 1);
        self.layer.shadowOpacity = 0.6;
        self.imageName = imageName;
        self.placeholdString = placeholdStr;
        [self setup];
    }
    return self;
}

- (void)setup {
    [self addSubview:self.imageView];
    [self addSubview:self.textLabel];
    [self addSubViewConstraints];
}

#pragma mark - system dataSource and delegate

#pragma mark - private methods

- (void)addSubViewConstraints {
    CGFloat top = (self.viewHeight - 19.0) * 0.5;
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(19, 19));
        make.top.mas_offset(top);
        make.left.mas_equalTo(25);
    }];
    [self.textLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.imageView.mas_right).offset(12);
        make.centerY.equalTo(self.imageView);
    }];
}


#pragma mark - getters and setters
- (UIImageView *)imageView
{
    if (_imageView == nil) {
        _imageView = [[UIImageView alloc] init];
        _imageView.image = [UIImage imageNamed:self.imageName];
    }
    return _imageView;
}


- (UILabel *)textLabel
{
    if (_textLabel == nil) {
        _textLabel = [[UILabel alloc] init];
        _textLabel.textColor = UIColor.auxiliaryTextLight;
        _textLabel.text = self.placeholdString;
        _textLabel.font = [UIFont gmFont:14];
    }
    return _textLabel;
}

- (CGFloat)viewHeight {
    return 49.0;
}

@end
