//
//  ALGroupTableHeaderView.h
//  GMAlpha
//
//  Created by zhb on 2018/11/24.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "ALGroupDetailObject.h"
@class ALGroupTableHeaderView;

@protocol ALGroupTableHeaderViewDelegate <NSObject>
/** delegate : 更新高度 */
- (void)headerViewUpdateHeight:(CGFloat)height;
/** delegate : 关闭简介 */
- (void)headerViewCloseVerb:(CGFloat)height;
/** delegate : 点击了明星 */
- (void)headerViewClickStarView:(ALGroupTableHeaderView *)headerView;
@end

@interface ALGroupTableHeaderView : GMView
@property (nonatomic, strong) UIView *groupView;
@property (nonatomic, strong) UILabel *groupTitleLabel;
@property (nonatomic, strong) UILabel *groupDescLabel;
@property (nonatomic, strong) UIButton *groupCloseButton;

@property (nonatomic, strong) UIView *starView;
@property (nonatomic, strong) UIImageView *starIconView;
@property (nonatomic, strong) UILabel *starNameLabel;
@property (nonatomic, strong) UILabel *starDescLabel;
@property (nonatomic, strong) UIButton *starArrowButton;

@property (nonatomic, assign, readonly) CGFloat viewHeight;

@property (nonatomic, weak) id<ALGroupTableHeaderViewDelegate> delegate;


@property (nonatomic, strong) ALGroupDetailObject *dataObj;

@end

