//
//  ALGroupTableHeaderView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/24.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupTableHeaderView.h"

@interface ALGroupTableHeaderView()
@property (nonatomic, assign) CGFloat groupHeight;
@property (nonatomic, assign) CGFloat starHeight;
@property (nonatomic, assign) CGFloat starMargin;
@property (nonatomic, assign) CGFloat viewHeight;

@end

@implementation ALGroupTableHeaderView

- (void)setDataObj:(ALGroupDetailObject *)dataObj {
    if (dataObj == nil) return;
    _dataObj = dataObj;
    //1.简介部分
    if (dataObj.group.isDesc) {
        self.groupView.hidden = NO;
        self.groupDescLabel.text = dataObj.group.desc;
        CGFloat textheight = [dataObj.group.desc sizeWithFont:[UIFont gmFont:14] boundSize:CGSizeMake(MAINSCREEN_WIDTH-30, MAXFLOAT)].height;
        self.groupHeight = textheight + 50.0;
    }
    else {
        self.groupView.hidden = YES;
        self.groupDescLabel.text = @"";
        self.groupHeight = 0;
    }
    //2.明星部分
    if (dataObj.celebrity.icon == nil) {
        self.starView.hidden = YES;
        self.starHeight = 0;
        self.starMargin = 0;
    }
    else {
        self.starView.hidden = NO;
        self.starHeight = 75;
        self.starMargin = 20;
        NSURL *starIcon = [NSURL URLWithString:dataObj.celebrity.icon];
        [self.starIconView sd_setImageWithURL:starIcon placeholderImage:[self defaultStarIcon]];
        self.starNameLabel.text = dataObj.celebrity.name;
        self.starDescLabel.text = dataObj.celebrity.pickDesc;
    }
    
    [self updatelayouts];
    //计算总高度
    CGFloat viewHeight = self.groupHeight + self.starHeight + self.starMargin;
    if (viewHeight != self.viewHeight) {
        self.viewHeight = viewHeight;
        if ([self.delegate respondsToSelector:@selector(headerViewUpdateHeight:)]) {
            [self.delegate headerViewUpdateHeight:_viewHeight];
        }
    }
}

- (void)setup {
    [super setup];
    self.backgroundColor = UIColor.background;
    self.viewHeight = 0;
    [self setupSubviews];
    [self setupLayouts];
}


- (void)setupSubviews {
    [self addSubview:self.groupView];
    [self addSubview:self.starView];
    //groupView
    [self.groupView addSubview:self.groupCloseButton];
    [self.groupView addSubview:self.groupTitleLabel];
    [self.groupView addSubview:self.groupDescLabel];
    //starView
    [self.starView addSubview:self.starIconView];
    [self.starView addSubview:self.starNameLabel];
    [self.starView addSubview:self.starDescLabel];
    [self.starView addSubview:self.starArrowButton];
}

- (void)setupLayouts {
    //1.groupView及subview
    [self.groupView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.equalTo(self);
        make.height.mas_greaterThanOrEqualTo(0);
    }];
    [self.groupCloseButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(10);
        make.right.mas_equalTo(-15);
        make.size.mas_equalTo(CGSizeMake(12, 12));
    }];
    [self.groupTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(30);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
    }];
    
    [self.groupDescLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self).offset(50);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
        make.bottom.mas_equalTo(-10);
    }];
    
    //2.starView及subview
    [self.starView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.groupView.mas_bottom).offset(10);
        make.left.right.bottom.equalTo(self);
        make.height.mas_equalTo(75);
        make.bottom.equalTo(self).offset(-10);
    }];
    [self.starIconView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(45, 45));
        make.left.mas_equalTo(15);
        make.centerY.mas_equalTo(0);
    }];
    [self.starNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.starIconView).offset(2);
        make.left.equalTo(self.starIconView.mas_right).offset(10);
        make.right.equalTo(self).offset(-30);
    }];
    [self.starDescLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.starNameLabel.mas_bottom).offset(2);
        make.left.equalTo(self.starNameLabel);
        make.right.equalTo(self.starNameLabel);
    }];
    [self.starArrowButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(10);
        make.top.bottom.mas_equalTo(0);
        make.right.mas_equalTo(-15);
    }];
}

- (void)updatelayouts {
    [self.groupView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(self.groupHeight);
    }];
    if (self.starHeight == 0 ) {
        [self.starView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.groupView.mas_bottom).offset(0);
            make.left.right.equalTo(self);
            make.height.mas_equalTo(0);
            make.bottom.equalTo(self).offset(0);
        }];;

    }else {
        [self.starView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.groupView.mas_bottom).offset(10);
            make.left.right.equalTo(self);
            make.height.mas_equalTo(self.starHeight);
            make.bottom.equalTo(self).offset(-10);
        }];
    }
}

#pragma mark - action 事件
// action: 点击了 ❌
- (void)clickedGroupCloseButton:(UIButton *)sender {
    //用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    //1.更改model的属性
    self.dataObj.group.isDesc = NO;
    //2.更改frame
    _viewHeight = self.viewHeight - self.groupHeight;
    self.groupHeight = 0;
    [self updatelayouts];
    if ([self.delegate respondsToSelector:@selector(headerViewCloseVerb:)]) {
        [self.delegate headerViewCloseVerb:_viewHeight];
    }
    //3.网络
    [self requestCloseGroupDesc];
}

- (void)clickedStarView:(UITapGestureRecognizer *)tap {
    if ([self.delegate respondsToSelector:@selector(headerViewClickStarView:)]) {
        [self.delegate headerViewClickStarView:self];
    }
}

#pragma mark - 网络
- (void)requestCloseGroupDesc {
    NSDictionary *params = @{
                             @"group_id": @(self.dataObj.group.id)
                             };
    __weak __typeof(self)weakSelf = self;
    [GMNetworking requestOCWithApi:API_V1_GROUP_USER_DELETE_DESC method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
        if (weakSelf == nil) {return;}
        if (response.data == nil) {return;}
    }];
}


#pragma mark - private methods


#pragma mark - getters and setters
- (UIButton *)groupCloseButton {
    if (_groupCloseButton == nil) {
        _groupCloseButton = [[UIButton alloc] init];
        [_groupCloseButton setImage:[UIImage imageNamed:@"group_cross"] forState:UIControlStateNormal];
        [_groupCloseButton addTarget:self action:@selector(clickedGroupCloseButton:) forControlEvents:UIControlEventTouchDown];
    }
    return _groupCloseButton;
}

- (UILabel *)groupTitleLabel {
    if (_groupTitleLabel == nil) {
        _groupTitleLabel = [[UILabel alloc] init];
        _groupTitleLabel.textColor = UIColor.auxiliaryTextLight;
        _groupTitleLabel.font = [UIFont gmFont:14];
        _groupTitleLabel.text = @"小组信息:";
        [_groupTitleLabel setContentHuggingPriority:1000 forAxis:0];
        [_groupTitleLabel setContentHuggingPriority:1000 forAxis:1];
        [_groupTitleLabel setContentCompressionResistancePriority:1000 forAxis:0];
        [_groupTitleLabel setContentCompressionResistancePriority:1000 forAxis:1];
    }
    return _groupTitleLabel;
}

- (UILabel *)groupDescLabel {
    if (_groupDescLabel == nil) {
        _groupDescLabel = [[UILabel alloc] init];
        _groupDescLabel.textColor = UIColor.auxiliaryTextLight;
        _groupDescLabel.font = [UIFont gmFont:14];
        _groupDescLabel.numberOfLines = 0;
        _groupDescLabel.text = @"主鹿、禁CP，只允许发关于鹿晗的一切，发关晓彤的会被拉黑哦！搬运请勿带签、请标明出处，请遵守鹿晗全球联合会援会的规定。";
        [_groupDescLabel setContentHuggingPriority:1000 forAxis:0];
        [_groupDescLabel setContentHuggingPriority:1000 forAxis:1];
        [_groupDescLabel setContentCompressionResistancePriority:1000 forAxis:0];
        [_groupDescLabel setContentCompressionResistancePriority:1000 forAxis:1];
    }
    return _groupDescLabel;
}

- (UIView *)groupView {
    if (_groupView == nil) {
        _groupView = [[UIView alloc] init];
        _groupView.backgroundColor = UIColor.whiteColor;
        _groupView.layer.masksToBounds = YES;
    }
    return _groupView;
}

- (UIView *)starView {
    if (_starView == nil) {
        _starView = [[UIView alloc] init];
        _starView.backgroundColor = UIColor.whiteColor;
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedStarView:)];
        [_starView addGestureRecognizer:tap];
    }
    return _starView;
}

- (UIButton *)starArrowButton {
    if (_starArrowButton == nil) {
        _starArrowButton = [[UIButton alloc] init];
        [_starArrowButton setImage:[UIImage imageNamed:@"group_right_arrow"] forState:UIControlStateNormal];
    }
    return _starArrowButton;
}

- (UIImageView *)starIconView {
    if (_starIconView == nil) {
        _starIconView = [[UIImageView alloc] init];
        _starIconView.image = [UIImage imageNamed:@"user_setter_default_icon_new"];
        _starIconView.layer.cornerRadius = 45 * 0.5;
        _starIconView.clipsToBounds = YES;
    }
    return _starIconView;
}

- (UILabel *)starNameLabel {
    if (_starNameLabel == nil) {
        _starNameLabel = [[UILabel alloc] init];
        _starNameLabel.textColor = UIColor.headlineText;
        _starNameLabel.font = [UIFont gmFont:16];
        _starNameLabel.text = @"鹿晗";
    }
    return _starNameLabel;
}

- (UILabel *)starDescLabel {
    if (_starDescLabel == nil) {
        _starDescLabel = [[UILabel alloc] init];
        _starDescLabel.textColor = UIColor.auxiliaryTextLight;
        _starDescLabel.font = [UIFont gmFont:14];
        _starDescLabel.text = @"亚太最帅男星第41名";
    }
    return _starDescLabel;
}

- (UIImage *)defaultStarIcon {
    return [UIImage imageNamed:@"user_setter_default_icon_new"];
}


@end
