//
//  ALGroupTopicCell.m
//  GMAlpha
//
//  Created by zhb on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupTopicCell.h"
#import "ALGroupMedieView.h"
#import "ALRecommendUserView.h"

API_AVAILABLE(ios(9.0))
@interface ALGroupTopicCell()
@property (nonatomic, strong) UIView *authorInfoView;
@property (nonatomic, strong) UIImageView *authorIconImageView;
@property (nonatomic, strong) GMLabel *authorNameLabel;
@property (nonatomic, strong) GMLabel *authorPositionLabel;
@property (nonatomic, strong) UIButton *authorFollowButton;

@property (nonatomic, strong) ALRecommendUserView *followInfoView;
@property (nonatomic, strong) ALGroupMedieView *medieInfoView;

@property (nonatomic, strong) UIView *topicInfoView;
@property (nonatomic, strong) UILabel *topicTextLabel;
@property (nonatomic, strong) UIButton *topicshowButton;

@property (nonatomic, strong) UIView *replyInfoView;
@property (nonatomic, strong) UIView *replyGrayColorView;
@property (nonatomic, strong) UIImageView *userIconImageView;
@property (nonatomic, strong) UILabel *replyPlaceHolderLabel;
@property (nonatomic, strong) UIButton *voteButton;
@property (nonatomic, strong) UIButton *shareButton;
@property (nonatomic, strong) UIButton *threePointButton;
@property (nonatomic, strong) UILabel *voteCountLabel;
@property (nonatomic, strong) UIStackView *stackView;
@property (nonatomic, strong) UILabel *oneReplayLabel;
@property (nonatomic, strong) UILabel *twoReplayLabel;
@property (nonatomic, strong) UILabel *threeReplayLabel;
@property (nonatomic, strong) UIButton *lookRepliesButton;
@property (nonatomic, strong) UIButton *translateButton;
@property (nonatomic, assign) CGFloat followHeight;
@end



@implementation ALGroupTopicCell

- (void)setObj:(ALGroupTestObject *)obj {
    _obj = obj;
    self.authorFollowButton.selected = (obj.isShowFollow);
    [self.followInfoView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(self.followHeight);
    }];
    self.topicshowButton.selected = obj.isExpand;
    self.topicTextLabel.numberOfLines = (obj.isExpand ? 0 : 2) ;

//    CGSize temp1Size = CGSizeMake(MAINSCREEN_WIDTH-30, MAXFLOAT);
//    CGSize temp2Size = CGSizeMake(MAXFLOAT, 15);
//    NSString *twoStr = @"鹿晗2018北京场演唱会【终极应援方案】出炉了呦请关注。\n甜蜜蜜粉色玫瑰灯应援：在前奏响前。\n鹿晗2018北京场演唱会【终极应援方案】出炉了呦请关注，甜蜜蜜粉色玫瑰灯应援：在前奏响前";
//    NSString *oneStr = @"鹿晗2018北京场演唱会【终极应援方案】出炉了呦请关注。甜蜜蜜粉色玫瑰灯应援：在前奏响前,鹿晗2018北京场演唱会【终极应援方案】出炉了呦请关注，甜蜜蜜粉色玫瑰灯应援：在前奏响前";
//    CGFloat twoHeight = [oneStr sizeWithFont:[UIFont gmFont:15] boundSize:temp1Size lineSpacing:0].height;
//    
//    CGFloat onewidth = ([oneStr sizeWithFont:[UIFont gmFont:15] boundSize:temp2Size lineSpacing:0].width) / (oneStr.length);
//    CGFloat heightss = (obj.isExpand ? twoHeight : oneHeight);
    
    [self.topicTextLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        
    }];
    
}


#pragma mark - life cycle
- (void)setup {
    [super setup];
    [self.contentView addSubview:self.authorInfoView];
    [self.authorInfoView addSubview:self.authorIconImageView];
    [self.authorInfoView addSubview:self.authorNameLabel];
    [self.authorInfoView addSubview:self.authorPositionLabel];
    [self.authorInfoView addSubview:self.authorFollowButton];
    
    [self.contentView addSubview:self.followInfoView];
    [self.contentView addSubview:self.medieInfoView];
    
    [self.contentView addSubview:self.topicInfoView];
    [self.topicInfoView addSubview:self.topicTextLabel];
    [self.topicInfoView addSubview:self.topicshowButton];
    
    [self.contentView addSubview:self.replyInfoView];
    [self.replyInfoView addSubview:self.replyGrayColorView];
    [self.replyInfoView addSubview:self.userIconImageView];
    [self.replyInfoView addSubview:self.replyPlaceHolderLabel];
    [self.replyInfoView addSubview:self.voteButton];
    [self.replyInfoView addSubview:self.shareButton];
    [self.replyInfoView addSubview:self.threePointButton];
    [self.replyInfoView addSubview:self.voteCountLabel];
    
    [self.contentView addSubview:self.stackView];
    [self.stackView addArrangedSubview:self.oneReplayLabel];
    [self.stackView addArrangedSubview:self.twoReplayLabel];
    [self.stackView addArrangedSubview:self.threeReplayLabel];

    [self.contentView addSubview:self.lookRepliesButton];
    [self.contentView addSubview:self.translateButton];
}

- (void)cellConstraints {
    // authorInfoView部分
    [self.authorInfoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.equalTo(self.contentView);
        make.height.mas_equalTo(122 * 0.5);
    }];
    
    [self.authorIconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.authorInfoView).offset(15);
        make.centerY.equalTo(self.authorInfoView);
        make.size.mas_equalTo(CGSizeMake(35, 35));
    }];
    
    [self.authorNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.authorIconImageView.mas_top);
        make.left.equalTo(self.authorIconImageView.mas_right).offset(10);
    }];
    
    [self.authorPositionLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.authorNameLabel.mas_left);
        make.bottom.equalTo(self.authorIconImageView.mas_bottom);
    }];
    
    [self.authorFollowButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.authorInfoView.mas_right).offset(-19);
        make.centerY.equalTo(self.authorInfoView);
    }];
    
    // followInfoView
    [self.followInfoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.authorInfoView.mas_bottom);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(0);
    }];
    
    // medieInfoView
    [self.medieInfoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.followInfoView.mas_bottom);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(MAINSCREEN_WIDTH);
    }];
    
    // topic文字区
    [self.topicInfoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.medieInfoView.mas_bottom).offset(15);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
    }];
    
    [self.topicTextLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.bottom.mas_equalTo(0);
    }];
    
    [self.topicshowButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.bottom.mas_equalTo(0);
        make.width.mas_greaterThanOrEqualTo(30);
        make.height.mas_equalTo(22);
    }];
    
    // replayInfoView区
    [self.replyInfoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.topicInfoView.mas_bottom).offset(16);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
        make.height.mas_equalTo(29);
    }];
     
    [self.replyGrayColorView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.mas_equalTo(0);;
    }];
    [self.userIconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.replyGrayColorView).offset(5);
        make.size.mas_equalTo(CGSizeMake(20, 20));
        make.centerY.mas_equalTo(0);
    }];
    
    [self.replyPlaceHolderLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.userIconImageView.mas_right).offset(5);
        make.centerY.mas_equalTo(0);
    }];
    
    [self.voteButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.replyGrayColorView.mas_right).offset(25);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    [self.shareButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.voteButton.mas_right).offset(20);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    [self.threePointButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.shareButton.mas_right).offset(20);
        make.right.mas_equalTo(0);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    
    [self.voteCountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.voteButton.mas_centerY).offset(-2);
        make.left.equalTo(self.voteButton.mas_centerX).offset(3);
        make.height.mas_equalTo(11);
    }];
    
    // 评论区
    [self.stackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.replyInfoView.mas_bottom).offset(15);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
    }];
    
    [self.lookRepliesButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.stackView.mas_bottom).offset(16);
        make.left.mas_equalTo(15);
    }];
    [self.translateButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.stackView.mas_bottom).offset(16);
        make.left.equalTo(self.lookRepliesButton.mas_right).offset(15);
        make.height.mas_equalTo(15);
        make.height.equalTo(self.lookRepliesButton);
        make.bottom.mas_equalTo(-20).priority(750);
    }];
    
    [self.contentView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.equalTo(self);
    }];
}

- (void)updateCellConstraints {
    
    [super updateCellConstraints];
    
    
}





#pragma mark - system dataSource and delegate


#pragma mark - custom dataSource and delegate



#pragma mark - event response
- (void)clickedauthorFollowButton:(UIButton *)sender {
    NSLog(@"敲击了 authorFollowButton");
    sender.selected = !(sender.isSelected);
    self.obj.isShowFollow = sender.selected;
    [self.followInfoView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(self.followHeight);
    }];
    [self.stackView layoutIfNeeded];
    if ([self.delegate respondsToSelector:@selector(groupTopicCell:clickedFollowButton:)]) {
        [self.delegate groupTopicCell:self clickedFollowButton:sender];
    }
}

- (void)clickedTopicShowButton:(UIButton *)sender {
    //更改数据
    //刷新布局
    sender.selected = !(sender.isSelected);
    self.obj.isExpand = sender.selected;
    self.topicTextLabel.numberOfLines = (self.obj.isExpand ? 0 : 2) ;
    if ([self.delegate respondsToSelector:@selector(groupTopicCell:clickedFollowButton:)]) {
        [self.delegate groupTopicCell:self clickedFollowButton:sender];
    }
}

// 敲击了: 点赞
- (void)clickedVoteButton:(UIButton *)sender {
    sender.selected = !(sender.isSelected);
}

// 敲击了: 分享
- (void)clickedShareButton:(UIButton *)sender {
    
}

// 敲击了: ...
- (void)clickedThreePointButton:(UIButton *)sender {
    
}

// 敲击了 全部120条评论
- (void)clickedLookRepliesButton:(UIButton *)sender {
    
}

// 敲击了 在线翻译
- (void)clickedTranslateButton:(UIButton *)sender {
    
}
#pragma mark - private methods
- (void)updateRepiesLabelConstraints {
    [self.stackView removeArrangedSubview:self.oneReplayLabel];
    [self.stackView removeArrangedSubview:self.twoReplayLabel];
    [self.stackView removeArrangedSubview:self.threeReplayLabel];

    
    [self.stackView addArrangedSubview:self.oneReplayLabel];
    [self.stackView addArrangedSubview:self.twoReplayLabel];
    [self.stackView addArrangedSubview:self.threeReplayLabel];
}


#pragma mark - getters and setters
- (UIView *)authorInfoView {
    if (_authorInfoView == nil) {
        _authorInfoView = [[UIView alloc] init];
    }
    return _authorInfoView;
}

- (UIImageView *)authorIconImageView {
    if (_authorIconImageView == nil) {
        _authorIconImageView = [[UIImageView alloc] init];
        _authorIconImageView.image = [UIImage imageNamed:@"group_author_icon"];
        _authorIconImageView.layer.cornerRadius = 17.5;
        _authorIconImageView.layer.masksToBounds = YES;
    }
    return _authorIconImageView;
}

- (GMLabel *)authorNameLabel {
    if (_authorNameLabel == nil) {
        _authorNameLabel = [GMLabel labelWithTextAlignment:NSTextAlignmentLeft backgroundColor:[UIColor clearColor] textColor:UIColor.headlineText fontSize:14];
        _authorNameLabel.font = [UIFont gmLightFont:14];
        _authorNameLabel.text = @"苏珊珊";
    }
    return _authorNameLabel;
}

- (GMLabel *)authorPositionLabel {
    if (_authorPositionLabel == nil) {
        _authorPositionLabel = [GMLabel labelWithTextAlignment:NSTextAlignmentLeft backgroundColor:[UIColor clearColor] textColor:UIColor.auxiliaryTextDark fontSize:10];
        _authorPositionLabel.text = @"北京";
    }
    return _authorPositionLabel;
}

- (UIButton *)authorFollowButton {
    if (_authorFollowButton == nil) {
        _authorFollowButton = [[UIButton alloc] init];
        [_authorFollowButton setImage:[UIImage imageNamed:@"author_follow"] forState:UIControlStateNormal];
        [_authorFollowButton setImage:[UIImage imageNamed:@"author_no_follow"] forState:UIControlStateSelected];
        [_authorFollowButton addTarget:self action:@selector(clickedauthorFollowButton:) forControlEvents:UIControlEventTouchUpInside];
        [_authorFollowButton sizeToFit];
    }
    return _authorFollowButton;
}

- (ALRecommendUserView *)followInfoView {
    if (_followInfoView == nil) {
        _followInfoView = [[ALRecommendUserView alloc] init];
        _followInfoView.clipsToBounds = YES;
    }
    return _followInfoView;
}

- (ALGroupMedieView *)medieInfoView {
    if (_medieInfoView == nil) {
        _medieInfoView = [[ALGroupMedieView alloc] init];
        _medieInfoView.backgroundColor = UIColor.whiteColor;
    }
    return _medieInfoView;
}

- (UILabel *)topicTextLabel
{
    if (_topicTextLabel == nil) {
        _topicTextLabel = [[UILabel alloc] init];
        _topicTextLabel.textColor = UIColor.headlineText;
        _topicTextLabel.font = [UIFont gmFont:15];
        _topicTextLabel.numberOfLines = 2;
        _topicTextLabel.preferredMaxLayoutWidth = MAINSCREEN_WIDTH - 30;
        _topicTextLabel.text = @"鹿晗2018北京场演唱会【终极应援方案】出炉了呦请关注，甜蜜蜜粉色玫瑰灯应援：在前奏响前,鹿晗2018北京场演唱会【终极应援方案】出炉了呦请关注，甜蜜蜜粉色玫瑰灯应援：在前奏响前";
        
    }
    return _topicTextLabel;
}

- (UIView *)topicInfoView {
    if (_topicInfoView == nil) {
        _topicInfoView = [[UIView alloc] init];
        _topicInfoView.backgroundColor = UIColor.whiteColor;
    }
    return _topicInfoView;
}

/** _topicshowButton懒加载 -- 实质getter方法 */
- (UIButton *)topicshowButton
{
    if (_topicshowButton == nil) {
        _topicshowButton = [[UIButton alloc] init];
        [_topicshowButton setTitle:@"展开" forState:UIControlStateNormal];
        [_topicshowButton setTitleColor:UIColor.auxiliaryTextLight forState:UIControlStateNormal];
        _topicshowButton.titleLabel.font = [UIFont gmFont:15];
        [_topicshowButton sizeToFit];
        [_topicshowButton addTarget:self action:@selector(clickedTopicShowButton:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _topicshowButton;
}


- (UIView *)replyInfoView {
    if (_replyInfoView == nil) {
        _replyInfoView = [[UIView alloc] init];
        _replyInfoView.backgroundColor = UIColor.whiteColor;
    }
    return _replyInfoView;
}

- (UIView *)replyGrayColorView {
    if (_replyGrayColorView == nil) {
        _replyGrayColorView = [[UIView alloc] init];
        _replyGrayColorView.backgroundColor = UIColor.background;
        _replyGrayColorView.layer.cornerRadius = 10;
        _replyGrayColorView.layer.masksToBounds = YES;
    }
    return _replyGrayColorView;
}



- (UILabel *)replyPlaceHolderLabel {
    if (_replyPlaceHolderLabel == nil) {
        _replyPlaceHolderLabel = [[UILabel alloc] init];
        _replyPlaceHolderLabel.textColor = UIColor.auxiliaryTextLight;
        _replyPlaceHolderLabel.text = @"添加评论";
        _replyPlaceHolderLabel.font = [UIFont gmFont:13];
    }
    return _replyPlaceHolderLabel;
}


- (UIImageView *)userIconImageView {
    if (_userIconImageView == nil) {
        _userIconImageView = [[UIImageView alloc] init];
        _userIconImageView.image = [UIImage imageNamed:@"group_author_icon"];
        _userIconImageView.layer.cornerRadius = 10;
        _userIconImageView.layer.masksToBounds = YES;
    }
    return _userIconImageView;
}
- (UIButton *)voteButton {
    if (_voteButton == nil) {
        _voteButton = [[UIButton alloc] init];
        [_voteButton setImage:[UIImage imageNamed:@"group_no_vote"] forState:UIControlStateNormal];
        [_voteButton setImage:[UIImage imageNamed:@"group_vote"] forState:UIControlStateSelected];
        [_voteButton addTarget:self action:@selector(clickedVoteButton:) forControlEvents:UIControlEventTouchUpInside];
        [_voteButton sizeToFit];
    }
    return _voteButton;
}

- (UIButton *)shareButton {
    if (_shareButton == nil) {
        _shareButton = [[UIButton alloc] init];
        [_shareButton setImage:[UIImage imageNamed:@"group_share"] forState:UIControlStateNormal];
        [_shareButton addTarget:self action:@selector(clickedShareButton:) forControlEvents:UIControlEventTouchUpInside];
        [_shareButton sizeToFit];
    }
    return _shareButton;
}
- (UIButton *)threePointButton {
    if (_threePointButton == nil) {
        _threePointButton = [[UIButton alloc] init];
        [_threePointButton setImage:[UIImage imageNamed:@"group_three_point"] forState:UIControlStateNormal];
        [_threePointButton addTarget:self action:@selector(clickedThreePointButton:) forControlEvents:UIControlEventTouchUpInside];
        [_threePointButton sizeToFit];
    }
    return _threePointButton;
}

- (UILabel *)voteCountLabel {
    if (_voteCountLabel == nil) {
        _voteCountLabel = [[UILabel alloc] init];
        _voteCountLabel.textColor = UIColor.headlineText;
        _voteCountLabel.backgroundColor = UIColor.whiteColor;
        _voteCountLabel.text = @"3600";
        _voteCountLabel.font = [UIFont gmFont:10];
        _voteCountLabel.layer.cornerRadius = 2;
        _voteCountLabel.layer.masksToBounds = YES;
    }
    return _voteCountLabel;
}


- (UIStackView *)stackView {
    if (_stackView == nil) {
        _stackView = [[UIStackView alloc] init];
        _stackView.distribution = UIStackViewDistributionEqualSpacing;
        _stackView.alignment = UIStackViewAlignmentFirstBaseline;
        _stackView.axis = UILayoutConstraintAxisVertical;
        _stackView.spacing = 0;
    }
    return _stackView;
}

- (UILabel *)oneReplayLabel {
    if (_oneReplayLabel == nil) {
        _oneReplayLabel = [[UILabel alloc] init];
        _oneReplayLabel.textColor = UIColor.headlineText;
        _oneReplayLabel.backgroundColor = UIColor.whiteColor;
        _oneReplayLabel.textColor = UIColor.headlineText;
        _oneReplayLabel.font = [UIFont gmFont:13];
        _oneReplayLabel.numberOfLines = 0;
        _oneReplayLabel.text = @"闲闲:在前奏响起时,请关闭包";
    }
    return _oneReplayLabel;
}
- (UILabel *)twoReplayLabel {
    if (_twoReplayLabel == nil) {
        _twoReplayLabel = [[UILabel alloc] init];
        _twoReplayLabel.textColor = UIColor.headlineText;
        _twoReplayLabel.backgroundColor = UIColor.whiteColor;
        _twoReplayLabel.textColor = UIColor.headlineText;
        _twoReplayLabel.font = [UIFont gmFont:13];
        _twoReplayLabel.numberOfLines = 0;
        _twoReplayLabel.text = @"闲闲:在前奏响起时,请关闭包";
    }
    return _twoReplayLabel;
}
- (UILabel *)threeReplayLabel {
    if (_threeReplayLabel == nil) {
        _threeReplayLabel = [[UILabel alloc] init];
        _threeReplayLabel.textColor = UIColor.headlineText;
        _threeReplayLabel.backgroundColor = UIColor.whiteColor;
        _threeReplayLabel.textColor = UIColor.headlineText;
        _threeReplayLabel.font = [UIFont gmFont:13];
        _threeReplayLabel.numberOfLines = 0;
        _threeReplayLabel.text = @"小白兔白又白 > 闲闲：蜜粉色玫瑰灯应援：在前奏响起时！在前奏响起时,请关闭包";
    }
    return _threeReplayLabel;
}

- (UIButton *)lookRepliesButton {
    if (_lookRepliesButton == nil) {
        _lookRepliesButton = [[UIButton alloc] init];
        [_lookRepliesButton setTitle:@"全部120条评论" forState:UIControlStateNormal];
        [_lookRepliesButton setTitleColor:UIColor.auxiliaryTextLight forState:UIControlStateNormal];
        _lookRepliesButton.titleLabel.font = [UIFont gmFont:13];
        [_lookRepliesButton sizeToFit];
        [_lookRepliesButton addTarget:self action:@selector(clickedLookRepliesButton:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _lookRepliesButton;
}

- (UIButton *)translateButton {
    if (_translateButton == nil) {
        _translateButton = [[UIButton alloc] init];
        [_translateButton setTitle:@"在线翻译" forState:UIControlStateNormal];
        [_translateButton setTitleColor:UIColor.headlineText forState:UIControlStateNormal];
        _translateButton.titleLabel.font = [UIFont gmFont:13];
        [_translateButton sizeToFit];
        [_translateButton addTarget:self action:@selector(clickedTranslateButton:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _translateButton;
}

- (CGFloat)followHeight {
    CGFloat followInfoViewH = self.followInfoView.recommendUserViewHeight;
    return (self.obj.isShowFollow) ? followInfoViewH : 0;
}

@end
