//
//  ALGroupDetailViewModel.m
//  GMAlpha
//
//  Created by zhb on 2018/11/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupDetailViewModel.h"
#import "ALGroupDetailObject.h"

@implementation ALGroupDetailViewModel
- (instancetype)init
{
    self = [super init];
    if (self) {
        _remoteUrl = API_V1_GROUP_DETAIL;
        _deduplicationKey = @"id";

    }
    return self;
}

- (void)buildParams{
    _params = self.rqParamDict;
//    _params = @{
//                @"group_id":SafeNumber(@(self.groupId)),
//                @"topic_id":SafeNumber(@(self.topicId))
//                };
}

- (void)buildModelWithRemoteDic:(NSDictionary *)dic{
    if ([dic[@"error"] integerValue] != 0) {
        return;
    }
    NSDictionary *contentData = dic[@"data"];
    NSArray *topics = contentData[@"topics"];

    NSError *error = nil;
    self.contentObject = [[ALGroupDetailObject alloc] initWithDictionary:contentData error:&error];

    if ([topics isKindOfClass:[NSNull class]]) {
        return;
    }
    [self deduplicationForArray:topics buildModelBlock:^id(NSDictionary *dic) {
        ALTopicCardObject *obj = [[ALTopicCardObject alloc] initWithDictionary:dic error:nil];
        [obj doOptimize];
        return obj;
    }];

}


//- (NSInteger)topicId {
//    return _topicId ? : 0;
//}

@end
