//
//  ALFollowController.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/8.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "ALFollowController.h"
#import "ALGroupListVController.h"
#import "ALFollowCell.h"
#import "ALGroupHomeObject.h"

@interface ALFollowController ()

@end

@implementation ALFollowController
@synthesize viewModel;

- (void)initController {
    [super initController];
    self.viewModel = [[ALFollowViewModel alloc] init];
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [_table registerCell:[ALFollowCell class]];
    self.emptyView.imageNeedReload = YES;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.viewModel.dataArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    ALFollowCell *cell = [_table dequeueCell:[ALFollowCell class] forIndexPath:indexPath];
    cell.object = self.viewModel.dataArray[indexPath.row];
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return [ALFollowCell height];
}
-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    ALGroupHomeObject *groupObj = self.viewModel.dataArray[indexPath.row];
    if (groupObj == nil) return;
    NSInteger follow = 0;
    if (groupObj.ifFollow == YES) {
        follow = 1;
    }
    [Phobos track:@"group_home_click_group_card" attributes:@{@"page_name":self.pageName,
                                                              @"tab_name":@"attention",
                                                              @"group_id":@(groupObj.id),
                                                              @"position":@(indexPath.row),
                                                              @"is_attention":@(follow)
                                                              }];
    ALGroupListVController *toVc = [[ALGroupListVController alloc] initWithGroupId:groupObj.id];
    [self pushViewController:toVc];
}

- (void)emptyViewDidClickReload
{
    [self hideEmptyView];
    [self refreshList];
}

//- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
//{
//    [super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
//    [self hideEmptyView];
//}

@end
