//
//  ALGroupSearchResultController.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/29.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupSearchResultController.h"
#import "ALSearchBarView.h"
#import "ALGroupHomeSearchViewModel.h"
#import "ALGroupListVController.h"
#import "ALHotCell.h"
#import "ALGroupHomeObject.h"

@interface ALGroupSearchResultController ()<ALSearchBarViewDelegate>
/** 顶部searchBar */
@property (nonatomic, strong) ALSearchBarView *searchView;
/** 用户搜索词 */
@property (nonatomic, copy) NSString *searchString;
/** viewModel */
@property (nonatomic, strong) ALGroupHomeSearchViewModel *viewModel;

@end

@implementation ALGroupSearchResultController
@synthesize viewModel;

- (void)initController
{
    [super initController];
    
    self.viewModel = [[ALGroupHomeSearchViewModel alloc]init];
    self.immediateLoad = NO;
    self.pageName = @"group_home_search";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self setNav];
    
    [self setUI];
    
    [self setLayout];
    
    self.view.backgroundColor =RGBCOLOR_HEX(0xf4f3f8);
    
    [_table registerCell:[ALHotCell class]];

}

#pragma mark -- life cycle
- (void)setNav
{
    self.navigationBar.hidden = YES;
}

- (void)setUI
{
    [self.view addSubview:self.searchView];
}

- (void)setLayout
{
    [self.searchView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.mas_offset(0);
        make.height.mas_equalTo(OCNavigationBar.barHeight);
    }];
}

#pragma mark -- custom delegate
/** delegate : 返回 */
- (void)searchViewDidBack:(ALSearchBarView *)searchView
{
    [self.navigationController popViewControllerAnimated:YES];
}
/** delegate : 搜索 或 键盘搜索 */
- (void)searchView:(ALSearchBarView *)searchView searchString:(NSString *)searchString
{
    
    if (searchString.length == 0) {
        [self toast:@"没找到小组，请换个关键字试试"];
        return;
    }
    
    [Phobos track:@"group_home_search_click_hunt" attributes:@{@"page_name":self.pageName,
                                                               @"query":SafeString(searchString)
                                                               }];
    [self showLoading:nil];
    self.searchString = searchString;
    [self.viewModel fetchRemoteDataWithSearchString:searchString];
}
- (void)updateOtherUIData
{
    [super updateOtherUIData];
    [self hideLoading];
}
#pragma mark -- system delegate

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.viewModel.dataArray.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    ALGroupHomeObject *obj = self.viewModel.dataArray[indexPath.row];
    
    ALGroupListVController *controller = [[ALGroupListVController alloc] initWithGroupId:(obj.id)];
    [self pushViewController:controller];
    
//    ALGroupHomeObject *object = self.viewModel.dataArray[indexPath.row];
//    [Phobos track:@"group_home_click_group_card" attributes:@{@"page_name": self.pageName,
//                                                              @"tab_name": _tabName,
//                                                              @"group_id": @(object.id),
//                                                              @"position": @(indexPath.row),
//                                                              @"is_attention": @(object.ifFollow)
//                                                              }];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    ALHotCell *cell = [_table dequeueCell:[ALHotCell class] forIndexPath:indexPath];
    cell.object = self.viewModel.dataArray[indexPath.row];
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return [ALHotCell height];
}


#pragma mark -- getter

- (ALSearchBarView *)searchView
{
    if (!_searchView) {
        _searchView = [[ALSearchBarView alloc]init];
        _searchView.delegate = self;
    }
    return _searchView;
}


@end
