//
//  ALHotController.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/8.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "ALHotController.h"
#import "ALHotCell.h"
#import "ALGroupListVController.h"

@interface ALHotController ()

@end

@implementation ALHotController
@synthesize viewModel;

- (void)initController {
    [super initController];
    
     self.viewModel = [[ALHotViewModel alloc] init];
//    self.immediateLoad = NO;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [_table registerCell:[ALHotCell class]];
    self.emptyView.imageNeedReload = YES;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.viewModel.dataArray.count;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    ALGroupHomeObject *groupObj = self.viewModel.dataArray[indexPath.row];
    if (groupObj == nil) return;
    NSInteger follow = 0;
    if (groupObj.ifFollow == YES) {
        follow = 1;
    }
    [Phobos track:@"group_home_click_group_card" attributes:@{@"page_name":self.pageName,
                                                              @"tab_name":@"recommend",
                                                              @"group_id":@(groupObj.id),
                                                              @"position":@(indexPath.row),
                                                              @"is_attention":@(follow)
                                                              }];
    ALGroupListVController *controller = [[ALGroupListVController alloc] initWithGroupId:groupObj.id];
    [self pushViewController:controller];

}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    ALHotCell *cell = [_table dequeueCell:[ALHotCell class] forIndexPath:indexPath];
    cell.object = self.viewModel.dataArray[indexPath.row];
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return [ALHotCell height];
}

- (void)emptyViewDidClickReload
{
    [self hideEmptyView];
    [self refreshList];
}


@end
