//
//  GMGroupController.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/5.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "GMGroupController.h"
#import "ALCreateGroupController.h"
#import "GMSegmentViewWithRedBadge.h"
#import "ALHotController.h"
#import "ALFollowController.h"

#import "AL3DCaptureController.h"
#import "GMPopupBgView.h"
#import "ALNavSearchBarView.h"
#import "ALGroupSearchResultController.h"
#import "ALCreateGroupWebOneController.h"

#define  SEGMENT_WIDTH MAINSCREEN_WIDTH * 4/5
@interface GMGroupController ()<ALNavSearchBarViewDelegate>
@property (nonatomic, strong) GMSegmentViewWithRedBadge *segment;

@property (nonatomic, strong) ALNavSearchBarView *searchBarView;

@end

@implementation GMGroupController
- (void)initController {
    [super initController];
    self.pageName = @"group_home";    
}
- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.navigationBar.hidden = YES;
    // Do any additional setup after loading the view.
//    self.navigationBar.title = @"小组列表";
//    self.navigationBar.rightTitle = @"创建小组";
//    
//    self.navigationBar.leftTitle = @"打开3D 相机";
    
    [self.view addSubview:self.searchBarView];
    
    [self setupSubviews];
    [self hideLoading];
}

- (void)clickSearchBarMethod:(ClickWhereOneType)type
{
    switch (type) {
        case ClickWhereOneTypeSearchBar:
        {
            [Phobos track:@"page_click_search_wow" attributes:@{@"page_name":self.pageName}];
            
            ALGroupSearchResultController *controller = [[ALGroupSearchResultController alloc] init];
            [self pushViewController:controller];
        }
            break;
        case ClickWhereOneTypeRightBtn:
        {
            
            if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
                return;
            }
            
            [Phobos track:@"group_home_click_create_group"];
            ALCreateGroupWebOneController *webViewCtrl = [ALCreateGroupWebOneController new];
            [[AppDelegate navigation] pushViewController:webViewCtrl animated:YES];
        }
            break;
        default:
            break;
    }
}

- (void)rightButtonClicked:(OCNavigationBarButton *)button {
    [Phobos track:@"group_home_click_create_group"];
    ALCreateGroupController *controller = [[ALCreateGroupController alloc] init];
    [self pushViewController:controller];
}

- (void)backAction:(OCNavigationBarButton *)button {
//    AL3DScanController *vc = [[AL3DScanController alloc] init];
//    [self pushViewController:vc];
    
    AL3DCaptureController *vc = [[AL3DCaptureController alloc] init];
    [self pushViewController:vc];
    
//    ALUnreScanController *unre = [[ALUnreScanController alloc] init];
//    [self pushViewController:unre];
}
- (void)setupSubviews {
//    self.childContainer.con
    
    _segment = [[GMSegmentViewWithRedBadge alloc] init];
    [self.view addSubview:_segment];
    [_segment mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.navigationBar.mas_bottom);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(40);
    }];
    _segment.sectionTitles = @[@"推荐", @"关注"];
    __weak typeof(self)weakSelf = self;
    NSLog(@"%@",self.businessId);
    _segment.didSelectedBlock = ^(NSUInteger index){
        weakSelf.selectIndex = index;
        //切换tab
        [weakSelf switchToChildControllerAtIndex:index];
        //埋点
        [weakSelf segmentPhobosAtIndex:index]; //group_home_click_tab
    };
    [_segment layoutSegments];
    _segment.indicatorColor = RGBCOLOR_HEX(0x0093ff);
//    self.navigationBar.titleView = _segment;
    
    [self.view addSubview:self.childContainer];
    self.childContainerSize = CGSizeMake(MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - OCNavigationBar.barHeight - UITabBar.barHeight - 44);
    self.childScrollViewDidEndScroll = ^(NSInteger index) {
        weakSelf.selectIndex = index;
        [weakSelf.segment setSelectedSegmentIndex:index animated:YES];
    };
    [self.childContainer mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.mas_equalTo(0);
        make.top.equalTo(self.segment.mas_bottom);
    }];
    
   //案例
    ALHotController *controller = [[ALHotController alloc]  init];
    controller.needLogPV = NO;
    controller.pageName = self.pageName;
    //评价
    
    ALFollowController *followController = [[ALFollowController alloc]  init];
    followController.needLogPV = NO;
    followController.pageName = self.pageName;
    [self setFirstController:controller otherController:@[followController]];
}
- (void)segmentPhobosAtIndex:(NSInteger)index {
    NSString *tabName;
    if (index == 0) {
        tabName = @"recommend";
    }else if (index == 1){
        tabName = @"attention";
    }
    [Phobos track:@"group_home_click_tab" attributes:@{@"tab_name": tabName}];
}

- (ALNavSearchBarView *)searchBarView
{
    if (!_searchBarView) {
        _searchBarView = [[ALNavSearchBarView alloc] initWithImage:@"group_creat" titleStr:@"创建小组" placeholder:@"搜索小组" delegate:self frame:CGRectMake(0, 0, [ALNavSearchBarView searchBarViewSize].width, [ALNavSearchBarView searchBarViewSize].height)];
    }
    return _searchBarView;
}

@end
