//
//  ALHotCell.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/8.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "ALHotCell.h"

@implementation ALHotCell

- (void)setup {
    [super setup];
    
    _avatarImageView = [[GMImageView alloc] init];
    _markImage.image = [UIImage imageNamed:@"hot_icon"];
    _avatarImageView.layer.masksToBounds = YES;
    _avatarImageView.layer.cornerRadius = 20;
    _avatarImageView.backgroundColor = UIColor.background;
    [self.contentView addSubview:_avatarImageView];
    
    _markImage = [[GMImageView alloc] init];
    _markImage.image = [UIImage imageNamed:@"hot_mark"];
    [self.contentView addSubview:_markImage];
    
    _nameLabl = [GMLabel labelWithTextColor:UIColor.bodyText fontSize:16];
    _nameLabl.font = [UIFont gmBoldFont:16];
    _nameLabl.text = @"种草u研究室";
    _nameLabl.preferredMaxLayoutWidth = MAINSCREEN_WIDTH - 85;
    [self.contentView addSubview:_nameLabl];
    
    _contentLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight fontSize:14];
    _contentLabel.text = @"come on babay 就差你哦";
    _contentLabel.preferredMaxLayoutWidth = MAINSCREEN_WIDTH - 85;
    [self.contentView addSubview:_contentLabel];
    
//    [self.contentView addBottomLine];
    
}

- (void)cellConstraints {
    [_markImage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.avatarImageView.mas_bottom);
        make.right.equalTo(self.avatarImageView.mas_right);
        make.size.sizeOffset(CGSizeMake(11, 11));
    }];
    
    [_avatarImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(15);
        make.left.mas_equalTo(15);
        make.size.mas_equalTo(CGSizeMake(40, 40));
    }];
    
    [_nameLabl mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.avatarImageView.mas_right).offset(10);
        make.bottom.equalTo(self.avatarImageView.mas_centerY);
        make.right.mas_equalTo(-15);
    }];
    
    [_contentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.avatarImageView.mas_right).offset(10);
        make.top.equalTo(self.avatarImageView.mas_centerY);
//        make.top.equalTo(self.nameLabl.mas_bottom).offset(7);
        make.right.mas_equalTo(-15);
//        make.bottom.mas_equalTo(-13);
    }];
    [self.bottomLine mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(self.mas_left).offset(15);
        make.right.mas_equalTo(self.mas_right).offset(-15);
        make.bottom.mas_equalTo(0);
        make.height.mas_equalTo(ONE_PIXEL);
    }];
}

- (void)setObject:(ALGroupHomeObject *)object {
    _object = object;
    [self.avatarImageView setImageWithUrlString:_object.icon placeHolder:@""];
    self.nameLabl.text = _object.name;
    self.contentLabel.text = _object.desc;
    self.markImage.hidden = !_object.ifFollow;
}

+ (CGFloat)height
{
    return 72;
}

@end
