//
//  ALNavSearchBarView.h
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//


typedef NS_OPTIONS(NSUInteger, ClickWhereOneType) {
    /// 点击搜索框
    ClickWhereOneTypeSearchBar,
    /// 点击右边按钮
    ClickWhereOneTypeRightBtn
};

@protocol ALNavSearchBarViewDelegate <NSObject>

- (void)clickSearchBarMethod:(ClickWhereOneType)type;

@end

@interface ALNavSearchBarView : UIView

@property (nonatomic, weak) id<ALNavSearchBarViewDelegate>delegate;
/**
 * imageStr 右边图片
 * titleStr 右边按钮的文字
 * placeholder 搜索框的占位符
 * 都是必传参数，每个地方不一样，不传也会设有默认
 */
- (instancetype)initWithImage:(NSString *)imageStr titleStr:(NSString *)titleStr placeholder:(NSString *)placeholder delegate:(id<ALNavSearchBarViewDelegate>)delegate frame:(CGRect)frame;
/**
 * 此控件的size
 */
+ (CGSize)searchBarViewSize;

@end

