//
//  ALNavSearchBarView.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALNavSearchBarView.h"

@interface ALNavSearchBarView ()
/** 状态栏View */
@property (nonatomic, strong) GMView *statusView;
/** 搜索框的view */
@property (nonatomic, strong) GMView *searchView;
/** 搜索框的backView */
@property (nonatomic, strong) GMView *backView;
/** 搜索放大镜图片🔍 */
@property (nonatomic, strong) GMImageView *searchImageView;
/** 提示文字 */
@property (nonatomic, strong) GMLabel *placeholderLabel;
/** 右边图片 */
@property (nonatomic, strong) GMImageView *btnImageView;
/** 右边的文字 */
@property (nonatomic, strong) GMLabel *rightLabel;
/** 覆盖在可点击的文字的button */
@property (nonatomic, strong) UIButton *clickButton;
/** 外部传入文字 */
@property (nonatomic, copy) NSString *titleStr;
/** 外部传入图片 */
@property (nonatomic, copy) NSString *imageStr;
/** 外部传入占位文字 */
@property (nonatomic, copy) NSString *placeholder;
/** 右边没有内容，重新布局 */
@property (nonatomic, assign) BOOL isChangeLayout;

@end

@implementation ALNavSearchBarView

- (instancetype)initWithImage:(NSString *)imageStr titleStr:(NSString *)titleStr placeholder:(NSString *)placeholder delegate:(id<ALNavSearchBarViewDelegate>)delegate frame:(CGRect)frame
{
    if (self = [super initWithFrame:frame])
    {        
        [self setValueImage:imageStr titleStr:titleStr placeholder:placeholder delegate:delegate];
        
        [self setUI];
        
        [self setLayout];
    }
    return self;
}

- (void)setValueImage:(NSString *)imageStr titleStr:(NSString *)titleStr placeholder:(NSString *)placeholder delegate:(id<ALNavSearchBarViewDelegate>)delegate
{
    self.titleStr = titleStr;
    
    self.imageStr = imageStr;
    
    self.placeholder = placeholder;
    
    self.delegate = delegate;
    ///
    if (self.imageStr)
    {
        self.btnImageView.image = [UIImage imageNamed:self.imageStr];
    }
    else
    {
        self.btnImageView.hidden = YES;
    }
    ///右边文字
    if (self.titleStr)
    {
        self.rightLabel.text = self.titleStr;
    }
    else
    {
        self.rightLabel.hidden = YES;
    }
    ///点击按钮
    if (self.titleStr == nil && self.imageStr == nil)
    {
        self.clickButton.hidden = YES;
        self.isChangeLayout = YES;
    }
    else
    {
        self.clickButton.hidden = NO;
        self.isChangeLayout = NO;
    }
    ///占位文字
    if (self.placeholder) {
        self.placeholderLabel.text = self.placeholder;
    }
}

#pragma mark--click Method
- (void)clickRightButtonMethod
{
    if ([self.delegate respondsToSelector:@selector(clickSearchBarMethod:)]) {
        [self.delegate clickSearchBarMethod:(ClickWhereOneTypeRightBtn)];
    }
}
- (void)backViewClickMethod
{
    if ([self.delegate respondsToSelector:@selector(clickSearchBarMethod:)]) {
        [self.delegate clickSearchBarMethod:(ClickWhereOneTypeSearchBar)];
    }
}

#pragma mark--sys Method
+ (CGSize)searchBarViewSize
{
    return CGSizeMake(MAINSCREEN_WIDTH, OCNavigationBar.barHeight);
}

- (void)setUI
{
    self.backgroundColor = UIColor.whiteColor;
    [self addSubview:self.statusView];
    [self addSubview:self.searchView];
    [self.searchView addSubview:self.rightLabel];
    [self.searchView addSubview:self.btnImageView];
    [self.searchView addSubview:self.clickButton];
    [self.searchView addSubview:self.backView];
    [self.backView addSubview:self.searchImageView];
    [self.backView addSubview:self.placeholderLabel];
}

- (void)setLayout
{
    //文字的宽度
    CGFloat titleWidth = [ALHelpManager getWidthOfString:self.titleStr font:[UIFont systemFontOfSize:15] height:20];
    
    if (titleWidth>65) {
        titleWidth = 65;
    }
    //搜索框距离右边的距离 文字的宽度 + 文字与图片的间距 + 图片的宽度 + 搜索框距离图片的距离 + 文字距离右边的间距
    CGFloat rightFloat = titleWidth + 2.5 + 20 + 15 + 15;
    
    [self.statusView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.right.equalTo(self);
        make.height.mas_equalTo(OCNavigationBar.statusBarHeight);
    }];
    [self.searchView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self);
        make.height.mas_equalTo(44);
        make.top.equalTo(self.statusView.mas_bottom);
    }];
    [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.searchView.mas_left).offset(15);
        make.height.mas_equalTo(32);
        make.centerY.equalTo(self.searchView.mas_centerY);
        if (self.isChangeLayout == YES)
        {
            make.right.equalTo(self.searchView.mas_right).offset(-15);
        }
        else
        {
            make.right.equalTo(self.searchView.mas_right).offset(-rightFloat);
        }
    }];
    [self.searchImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.backView.mas_left).offset(12);
        make.centerY.equalTo(self.backView.mas_centerY);
    }];
    [self.rightLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        if (titleWidth>65) {
            make.size.mas_equalTo(CGSizeMake(titleWidth, 20));
        }
        make.right.equalTo(self.searchView.mas_right).offset(-15);
        make.centerY.equalTo(self.backView.mas_centerY);
    }];
    [self.btnImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.backView.mas_centerY);
        make.right.equalTo(self.rightLabel.mas_left).offset(-2.5);
        make.size.mas_equalTo(CGSizeMake(17, 16));
    }];
    [self.placeholderLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.searchImageView.mas_right).offset(4);
        make.centerY.equalTo(self.backView.mas_centerY);
    }];
    [self.clickButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(20);
        make.right.equalTo(self.rightLabel.mas_right);
        make.left.equalTo(self.btnImageView.mas_left);
        make.centerY.equalTo(self.backView.mas_centerY);
    }];
}

- (GMView *)backView
{
    if (!_backView) {
        _backView = [[GMView alloc]init];
        _backView.backgroundColor = UIColor.background;
        _backView.layer.cornerRadius = 5.0f;
        _backView.layer.masksToBounds = YES;
        UITapGestureRecognizer *tapGest = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(backViewClickMethod)];
        [_backView addGestureRecognizer:tapGest];
    }
    return _backView;
}
- (GMImageView *)searchImageView
{
    if (!_searchImageView) {
        _searchImageView = [[GMImageView alloc]initWithImage:[UIImage imageNamed:@"group_search"]];
    }
    return _searchImageView;
}
- (GMLabel *)placeholderLabel
{
    if (!_placeholderLabel) {
        _placeholderLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight fontSize:14];
        _placeholderLabel.text = @"搜索";
    }
    return _placeholderLabel;
}
- (GMImageView *)btnImageView
{
    if (!_btnImageView) {
        _btnImageView = [[GMImageView alloc]initWithImage:[UIImage imageNamed:@"group_creat"]];
    }
    return _btnImageView;
}
- (GMLabel *)rightLabel
{
    if (!_rightLabel) {
        _rightLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x2d9aff) fontSize:16];
        _rightLabel.text = @"创建小组";
    }
    return _rightLabel;
}
- (UIButton *)clickButton
{
    if (!_clickButton) {
        _clickButton = [UIButton buttonWithType:(UIButtonTypeCustom)];
        [_clickButton addTarget:self action:@selector(clickRightButtonMethod) forControlEvents:(UIControlEventTouchUpInside)];
    }
    return _clickButton;
}

- (GMView *)statusView
{
    if (!_statusView) {
        _statusView = [[GMView alloc] init];
    }
    return _statusView;
}

- (GMView *)searchView
{
    if (!_searchView) {
        _searchView = [[GMView alloc] init];
    }
    return _searchView;
}

@end
