//
//  ALGroupHomeSearchViewModel.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/29.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupHomeSearchViewModel.h"
#import "ALGroupSearchResultListModel.h"


@interface ALGroupHomeSearchViewModel ()

@property (nonatomic, copy) NSString *searchString;

@end

@implementation ALGroupHomeSearchViewModel

- (instancetype)init
{
    self = [super init];
    if (self) {
        _searchString = @"";
        _remoteUrl = API_GROUP_HOME_SEARCH;
    }
    return self;
}

- (void)buildParams{
    _params = @{
                @"query":self.searchString,
                @"page":@(self.page),
                @"couont":@(10)
                };
}

- (void)buildModelWithRemoteDic:(NSDictionary *)dic{
    if ([dic[@"error"] integerValue] != 0) {
        return;
    }
    NSDictionary *contentData = dic[@"data"];
    NSError *error = nil;
    self.contentObject = [[ALGroupSearchResultListModel alloc] initWithDictionary:contentData error:&error];
    if (self.contentObject.groups.count == 0) {
        [AppDelegate.visibleController toast:@"没找到小组，请换个关键字试试"];
    }
    [self.dataArray addObjectsFromArray:self.contentObject.groups];
}

- (void)fetchRemoteDataWithSearchString:(NSString *)searchString {
    self.searchString = searchString;
    self.page = 1;
    [self fetchRemoteData];
}

@end
