//
//  ALGroupInviteShareView.m
//  GMAlpha
//
//  Created by zhb on 2018/11/20.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupInviteShareView.h"
#import "GMShareSDK.h"

@interface ALShareWabView: GMView
@property (nonatomic, strong) UIImageView *imageView;
@property (nonatomic, strong) UILabel *textLabel;
- (instancetype)initWithImageName:(NSString *)imageName text:(NSString *)text;
@end
@implementation ALShareWabView

#pragma mark - life cycle
- (instancetype)initWithImageName:(NSString *)imageName text:(NSString *)text {
    ALShareWabView *shareView = [[ALShareWabView alloc] init];
    shareView.imageView.image = [UIImage imageNamed:imageName];
    shareView.textLabel.text = text;
    return shareView;
}

- (void)setup {
    [super setup];
    [self addSubview:self.imageView];
    [self addSubview:self.textLabel];
    [self addConstraintForSubviews];
}

- (void)addConstraintForSubviews {
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(35, 35));
        make.top.mas_equalTo(0);
        make.centerX.mas_equalTo(0);
    }];
    [self.textLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.imageView.mas_bottom).offset(8);
        make.left.right.mas_equalTo(0);
    }];
}

#pragma mark - getters and setters
- (UIImageView *)imageView {
    if (_imageView == nil) {
        _imageView = [UIImageView new];
        _imageView.backgroundColor = UIColor.yellowColor;
    }
    return _imageView;
}

- (UILabel *)textLabel {
    if (_textLabel == nil) {
        _textLabel = [[UILabel alloc] init];
        _textLabel.textAlignment = NSTextAlignmentCenter;
        _textLabel.textColor = UIColor.auxiliaryTextLight;
        _textLabel.font = [UIFont gmFont:13];
    }
    return _textLabel;
}
@end

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

@interface ALGroupInviteShareView()
@property (nonatomic, strong) UIView *backView;
@property (nonatomic, strong) UILabel *titleLb;

@property (nonatomic, strong) UIStackView *stackView;
@property (nonatomic, strong) ALShareWabView *chatView;
@property (nonatomic, strong) ALShareWabView *sinaView;
@property (nonatomic, strong) ALShareWabView *friendView;
@property (nonatomic, strong) ALShareWabView *qqView;

@end
@implementation ALGroupInviteShareView

#pragma mark - life cycle
- (void)setup {
    [super setup];
    self.backgroundColor = UIColor.background;
    [self addSubview:self.backView];
    [self.backView addSubview:self.titleLb];
    
    [self.backView addSubview:self.chatView];
    [self.backView addSubview:self.sinaView];
    [self.backView addSubview:self.friendView];
    [self.backView addSubview:self.qqView];
    
    [self addConstraintForSubviews];
}

- (void)addSubviewForStackView {
    [self.stackView addArrangedSubview:self.chatView];
    [self.stackView addArrangedSubview:self.sinaView];
    [self.stackView addArrangedSubview:self.friendView];
    [self.stackView addArrangedSubview:self.qqView];
}
- (void)addConstraintForSubviews {
    [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.insets(UIEdgeInsetsMake(10, 0, 10, 0));
    }];
    
    [self.titleLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(25);
        make.centerX.mas_equalTo(0);
        make.left.right.mas_equalTo(0);
    }];
    
    NSArray *wadArray = @[self.chatView, self.sinaView, self.friendView, self.qqView];
    [wadArray mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(66);
        make.size.mas_equalTo(CGSizeMake(40, 58));
    }];
    [wadArray mas_distributeViewsAlongAxis:MASAxisTypeHorizontal withFixedItemLength:40 leadSpacing:40 tailSpacing:40];
}


#pragma mark - action 事件
- (void)sharetoPlatform:(GMSharePlatform)platform {
    //埋点
    if ([self.delegate respondsToSelector:@selector(shareView:selectedPlatform:)]) {
        [self.delegate shareView:self selectedPlatform:platform];
    }
    if (![GMShareSDK isClientInstalled:platform] && (platform == GMSharePlatformWechatTimeline | platform == GMSharePlatformWechatSession)) {
        //QQ和新浪支持web分享，只有微信不支持，这里优化下提示语
        [GMHudModule toast:@"您未安装微信客户端"];
        return;
    }
    
    NSString *title = @"";
    NSString *content = @"";
    NSString *image = self.shareData.image;
    NSString *shareUrl = self.shareData.url;
    shareUrl = [shareUrl stringByAppendingFormat:@"&channel=%@",[GMShareSDK shareChannel:platform]];
    NSString *user_id = [NSString stringWithFormat:@"%zd",[GMLoginManager shareInstance].user.userId];
    if (![GMLoginManager shareInstance].isVisitor) {
        shareUrl = [shareUrl stringByAppendingFormat:@"&from_user_id=%@",user_id];
    }
    
    switch (platform) {
            
        case GMSharePlatformWechatSession://微信好友
            title = self.shareData.wechat.title;
            content = self.shareData.wechat.content;
            break;
        case GMSharePlatformWechatTimeline://微信朋友圈
            title = self.shareData.wechatline.title;
            content = self.shareData.wechatline.content;
            break;
        case GMSharePlatformSinaWeibo://新浪微博
            title = self.shareData.weibo.title;
            content = self.shareData.weibo.content;
            break;
        case GMSharePlatformQQFriend:
            title = self.shareData.qq.title;
            content = self.shareData.qq.content;
            break;
        default:
            return;
    }
    NSMutableDictionary *mdict = [NSMutableDictionary dictionary];
    mdict[@"title"] = SafeString(title);
    mdict[@"content"] = SafeString(content);
    mdict[@"images"] = SafeString(image);
    mdict[@"url"] =  SafeString(shareUrl);
    [[GMShareSDK shareInstance] share:platform parameters:mdict onStateChanged:^(GMShareResponseState state, NSError *error) {
        if (state == GMShareResponseStateSuccess) {
            [GMHudModule toast:@"分享成功"];
        } else if(state == GMShareResponseStateCancel) {
            [GMHudModule toast:@"取消分享"];
        } else if(state == GMShareResponseStateFail) {
            [GMHudModule toast:@"分享失败"];
        }
    }];
    
}
- (void)clickedChat {
    
    [self sharetoPlatform:GMSharePlatformWechatSession];
}
- (void)clickedSina {
    
    [self sharetoPlatform:GMSharePlatformSinaWeibo];
}
- (void)clickedFriend {
    
    [self sharetoPlatform:GMSharePlatformWechatTimeline];
}
- (void)clickedQQ {
    
    [self sharetoPlatform:GMSharePlatformQQFriend];
}

#pragma mark - getters and setters
- (UIView *)backView {
    if (_backView == nil) {
        _backView = [UIView new];
        _backView.backgroundColor = UIColor.whiteColor;
    }
    return _backView;
}

- (UILabel *)titleLb {
    if (_titleLb == nil) {
        _titleLb = [[UILabel alloc] init];
        _titleLb.backgroundColor = [UIColor whiteColor];
        _titleLb.textAlignment = NSTextAlignmentCenter;
        _titleLb.textColor = RGBCOLOR_HEX(0x464646);
        _titleLb.font = [UIFont gmBoldFont:16];
        _titleLb.text = @"邀请好友";
    }
    return _titleLb;
}

- (UIStackView *)stackView {
    if (_stackView == nil) {
        _stackView = [[UIStackView alloc] init];
        _stackView.backgroundColor = [UIColor whiteColor];
        _stackView.distribution = UIStackViewDistributionEqualSpacing;
        _stackView.alignment = UIStackViewAlignmentTop;
        _stackView.axis = UILayoutConstraintAxisHorizontal;
        _stackView.spacing = 0;
    }
    return _stackView;
}

- (ALShareWabView *)chatView {
    if (_chatView == nil) {
        _chatView = [[ALShareWabView alloc] initWithImageName:@"share_chat" text:@"微信"];
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedChat)];
        [_chatView addGestureRecognizer:tap];
    }
    return _chatView;
}

- (ALShareWabView *)sinaView {
    if (_sinaView == nil) {
        _sinaView = [[ALShareWabView alloc] initWithImageName:@"share_sina" text:@"新浪"];
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedSina)];
        [_sinaView addGestureRecognizer:tap];
    }
    return _sinaView;
}

- (ALShareWabView *)friendView {
    if (_friendView == nil) {
        _friendView = [[ALShareWabView alloc] initWithImageName:@"share_friend" text:@"朋友圈"];
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedFriend)];
        [_friendView addGestureRecognizer:tap];
    }
    return _friendView;
}

- (ALShareWabView *)qqView {
    if (_qqView == nil) {
        _qqView = [[ALShareWabView alloc] initWithImageName:@"share_qq" text:@"QQ"];
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedQQ)];
        [_qqView addGestureRecognizer:tap];
    }
    return _qqView;
}

@end
