//
//  ALGroupVerbCell.m
//  GMAlpha
//
//  Created by zhb on 2018/11/13.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupVerbStyle1Cell.h"

@interface ALGroupVerbStyle1Cell ()

@end

@implementation ALGroupVerbStyle1Cell
- (void)showNormalDataWithViewModel:(ALGroupConfigModel *)normalObj atIndexPath:(NSIndexPath *)indexPath
{
    self.leftLabel.text = normalObj.title;
    self.bottomLine.hidden = normalObj.isHidenBottomLine;
}

- (void)showData:(ALGroupInviteObject *)obj atIndexPath:(NSIndexPath *)indexPath
{
    NSInteger row = indexPath.row;
    switch (row) {
        case 0:
        {
            self.rightLabel.text = obj.creatorName;
            self.arrowButton.hidden = NO;
        }
            break;
        case 1:
        {
            self.rightLabel.text = obj.userNumStr;
            self.arrowButton.hidden = NO;
        }
            break;
        case 2:
        {
            self.rightLabel.text = @"";
            self.arrowButton.hidden = !(obj.isCreator);
        }
            break;
        default:
        {
            self.rightLabel.text = @"";
            self.arrowButton.hidden = NO;
        }
            break;
    }
}



- (void)setup {
    [super setup];
    [self.contentView addSubview:self.leftLabel];
    [self.contentView addSubview:self.rightLabel];
    [self.contentView addSubview:self.arrowButton];
    self.bottomLine.backgroundColor = RGBCOLOR_HEX(0xE5E5E5);
    [self addConstraintForSubviews];
}

- (void)addConstraintForSubviews {
    [self.leftLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.centerY.mas_equalTo(0);
        make.height.mas_equalTo(55);
    }];
    
    [self.rightLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.leftLabel.mas_right).offset(5);
        make.top.bottom.mas_equalTo(0);
        make.height.mas_equalTo(55);
        make.right.mas_equalTo(-32);
    }];
    
    [self.arrowButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(7.5, 11.5));
        make.left.equalTo(self.rightLabel.mas_right);
        make.right.mas_equalTo(-15);
        make.centerY.mas_equalTo(0);
    }];
    
    [self.bottomLine mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
        make.bottom.mas_equalTo(0);
        make.height.mas_equalTo(0.5);
    }];
    
}

- (void)clickedArrowButtonButton:(UIButton *)sender {
    if ([self.delegate respondsToSelector:@selector(style1Cell:clickedArrowButton:)]) {
        [self.delegate style1Cell:self clickedArrowButton:sender];
    }
}

- (UILabel *)leftLabel
{
    if (_leftLabel == nil) {
        _leftLabel = [[UILabel alloc] init];
        _leftLabel.textColor = UIColor.bodyText;
        _leftLabel.font = [UIFont gmBoldFont:16];
        _leftLabel.textAlignment = NSTextAlignmentLeft;
        [_leftLabel setContentHuggingPriority:275 forAxis:0];
        [_leftLabel setContentCompressionResistancePriority:775 forAxis:0];
    }
    return _leftLabel;
}

- (UILabel *)rightLabel
{
    if (_rightLabel == nil) {
        _rightLabel = [[UILabel alloc] init];
        _rightLabel.textColor = RGBCOLOR_HEX(0x0093FF);
        _rightLabel.font = [UIFont gmFont:14];
        _rightLabel.textAlignment = NSTextAlignmentRight;
    }
    return _rightLabel;
}

- (UIButton *)arrowButton
{
    if (_arrowButton == nil) {
        _arrowButton = [[UIButton alloc] init];
        [_arrowButton setImage:[UIImage imageNamed:@"group_right_arrow"] forState:UIControlStateNormal];
        [_arrowButton addTarget:self action:@selector(clickedArrowButtonButton:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _arrowButton;
}

@end
