//
//  ALALGroupVerbStyle2Cell.m
//  GMAlpha
//
//  Created by zhb on 2018/11/13.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupVerbStyle2Cell.h"
@interface ALGroupVerbStyle2Cell ()
@end

@implementation ALGroupVerbStyle2Cell
- (void)showNormalDataWithViewModel:(ALGroupConfigModel *)normalObj atIndexPath:(NSIndexPath *)indexPath
{}

- (void)showData:(ALGroupInviteObject *)obj atIndexPath:(NSIndexPath *)indexPath
{
    NSMutableParagraphStyle *paragraphStyle = [NSMutableParagraphStyle new];
    paragraphStyle.lineSpacing = 7;// 字体的行间距
    NSDictionary *attributes = @{
                                 NSFontAttributeName:[UIFont gmFont:14],
                                 NSForegroundColorAttributeName : UIColor.auxiliaryTextLight,
                                 NSParagraphStyleAttributeName:paragraphStyle
                                 };
    NSString *descString = obj.desc ? : @"";
    self.contentLabel.attributedText = [[NSAttributedString alloc] initWithString:descString attributes:attributes];
}

- (void)setup {
    [super setup];
    [self.contentView addSubview:self.contentLabel];
    self.bottomLine.backgroundColor = [UIColor clearColor];
    [self addConstraintForSubviews];
}

- (void)addConstraintForSubviews {
    [self.contentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.contentView).insets(UIEdgeInsetsMake(0, 15, 10, 15));
    }];
}


- (UILabel *)contentLabel
{
    if (_contentLabel == nil) {
        _contentLabel = [[UILabel alloc] init];
        _contentLabel.textColor = UIColor.auxiliaryTextLight;
        _contentLabel.font = [UIFont gmFont:14];
        _contentLabel.textAlignment = NSTextAlignmentLeft;
        _contentLabel.numberOfLines = 0;
    }
    return _contentLabel;
}

@end
