//
//  ALGroupInviteViewModel.m
//  GMAlpha
//
//  Created by zhb on 2018/11/13.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALGroupInviteViewModel.h"

@interface ALGroupInviteViewModel ()

@property (nonatomic, strong) NSArray *config;
@end


@implementation ALGroupInviteViewModel
- (instancetype)init
{
    self = [super init];
    if (self) {
        _remoteUrl = API_V1_GROUP_INVITE;
    }
    return self;
}

- (void)buildParams{
    _params = @{
                @"group_id":SafeNumber(@(self.groupId)),
                };
}

- (void)buildModelWithRemoteDic:(NSDictionary *)dic{
    if ([dic[@"error"] integerValue] != 0) {
        return;
    }
    NSDictionary *dataDict = dic[@"data"];
    NSError *error = nil;
    self.contentObject = [[ALGroupInviteObject alloc] initWithDictionary:dataDict error:&error];
    self.dataArray = [self.configArray mutableCopy];
    ALGroupConfigModel *obj = self.dataArray[3];
    obj.cellHeight = self.contentObject.descHeight;
}

- (NSArray *)configArray {
    if (!_configArray) {
        ALGroupConfigModel *config0 = [[ALGroupConfigModel alloc] init];
        config0.cellHeight = 55;
        config0.title = @"组长";
        
        ALGroupConfigModel *config1 = [[ALGroupConfigModel alloc] init];
        config1.cellHeight = 55;
        config1.title = @"组员";
        
        ALGroupConfigModel *config2 = [[ALGroupConfigModel alloc] init];
        config2.cellHeight = 55;
        config2.title = @"小组信息";
        config2.isHidenBottomLine = YES;

        ALGroupConfigModel *config3 = [[ALGroupConfigModel alloc] init];
        config3.cellHeight = 0;
        config3.title = @"";
        config3.isHidenBottomLine = YES;

        _configArray = @[config0, config1, config2, config3];
    }
    return _configArray;
}
@end
