//
//  GMHomeController.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/5.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "GMHomeController.h"
#import "ALHomeSearchVController.h"
#import "ALHomeHotViewController.h"
#import "ALHomeFollowController.h"
#import "WYSegmentView+Factory.h"
#import "ALNavSearchBarView.h"
#import "ALHomeAleartView.h"

@interface GMHomeController ()<ALNavSearchBarViewDelegate, ALHomeAleartViewDelegate>
@property (nonatomic, strong) WYSegmentView *segment;
@property (nonatomic, strong) ALNavSearchBarView *searchView;
@property (nonatomic, strong) ALHomeAleartView *aleartView;
@end

@implementation GMHomeController{
    ALHomeHotViewController *_leftController;
    ALHomeFollowController *_rightController;
}
#pragma mark - life cycle
- (void)initController
{
    [super initController];
    self.pageName = @"home";
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationBar.hidden = YES;
    [self.view addSubview:self.searchView];

    __weak __typeof(self)weakSelf = self;
    self.segment = [WYSegmentView myOrderListSegment];
    _segment.showIndicator = NO;
    _segment.bottomLine.hidden = YES;
    _segment.titleTextAttributes = @{
                                     NSFontAttributeName: [UIFont gmFont:16],
                                     NSForegroundColorAttributeName: RGBCOLOR_HEX(0x666666)
                                     };
    _segment.selectedTitleTextAttributes = @{
                                     NSFontAttributeName: [UIFont gmBoldFont:16],
                                     NSForegroundColorAttributeName: RGBCOLOR_HEX(0x282828)
                                     };

    _segment.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, 44);
    _segment.sectionTitles = @[@"推荐",@"关注"];
    [_segment layoutSegments];
    
    [self.view addSubview:self.childContainer];
    self.childContainerSize = CGSizeMake(MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - OCNavigationBar.barHeight - 44 - UITabBar.barHeight);
    [self.view insertSubview:_segment aboveSubview:self.childContainer];
    
    [self.segment mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.top.mas_equalTo(OCNavigationBar.barHeight);
        make.height.mas_equalTo(44);
    }];
    [self.childContainer mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.segment.mas_bottom).offset(0);
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
    }];

    _leftController = [[ALHomeHotViewController alloc] init];
    _rightController = [[ALHomeFollowController alloc] init];
    [self setFirstController:_leftController otherController:@[_rightController]];
    //顶部选择器的点击事件
    [_segment setDidSelectedBlock:^(NSUInteger index) {
        if (index == 0)
        {
            [Phobos track:@"home_click_uptab" attributes:@{@"tab_name":@"recommend"}];
        }
        else if (index == 1)
        {
            [Phobos track:@"home_click_uptab" attributes:@{@"tab_name":@"focus"}];
        }
        [weakSelf switchToChildControllerAtIndex:index];
    }];
    
    self.childScrollViewDidEndScroll = ^(NSInteger index) {
        [weakSelf.segment setSelectedSegmentIndex:index animated:YES];
    };
    
    [self setPopView];
    
    self.pageName = @"home";
}
- (void)setPopView
{
    
}
#pragma mark - system dataSource and delegate

#pragma mark - ALHomeNavigationViewDelegate
- (void)clickSearchBarMethod:(ClickWhereOneType)type {
    if (ClickWhereOneTypeSearchBar == type)
    {
        // 点击搜索框
        [Phobos track:@"page_click_search_wow" attributes:@{@"page_name":self.pageName}];
        ALHomeSearchVController *toVc = [[ALHomeSearchVController alloc] init];
        [self pushViewController:toVc];
    }
    else if (ClickWhereOneTypeRightBtn == type)
    {
        //点击了发帖
        [Phobos track:@"home_click_create_topic"];
        [self.aleartView showToView:[UIApplication sharedApplication].keyWindow];
    }
}

#pragma mark - ALHomeAleartViewDelegate methods
- (void)clickWhitchMethod:(ClickWhereButtonType)type
{
    if (type == ClickLeftPost)
    {
        //发帖
        [Phobos track:@"create_topic_wow_click" attributes:@{@"from":@"home",
                                                             @"type":@"create_topic"
                                                             }];
    }
    else if (type == ClickRightCard)
    {
        //打卡
        [Phobos track:@"create_topic_wow_click" attributes:@{@"from":@"home",
                                                             @"type":@"clockin"
                                                             }];
    }
}

#pragma mark - getters and setters

- (ALNavSearchBarView *)searchView {
    if (!_searchView) {
        _searchView = [[ALNavSearchBarView alloc] initWithImage:@"home_search_post" titleStr:@"发帖" placeholder:@"搜索" delegate:self frame:CGRectMake(0, 0, [ALNavSearchBarView searchBarViewSize].width, [ALNavSearchBarView searchBarViewSize].height)];
    }
    return _searchView;
}
- (ALHomeAleartView *)aleartView
{
    if (!_aleartView) {
        _aleartView = [[ALHomeAleartView alloc] initWithFrame:CGRectMake(0, MAINSCREEN_HEIGHT, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT) imgAndTitle:@[@[@"home_group_post",@"发帖"],@[@"home_group_card",@"打卡"]]];
        _aleartView.delegate = self;
    }
    return _aleartView;
}
@end
