//
//  ALHomeTopicCardObject.m
//  GMAlpha
//
//  Created by zhb on 2018/11/15.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALHomeTopicCardObject.h"
#import "Utility.h"

@implementation ALHomeCardDataPortraitObject

@end


@implementation ALHomeCardDataImageObject

@end

@implementation ALHomeTopicCardObject



- (NSMutableAttributedString *)attrContent {
    if (self.content.length <= 0 || self.content == nil) {
        return nil;
    }
    NSDictionary *attributesForStr = @{NSFontAttributeName:[UIFont systemFontOfSize:14.0]};
    
    NSMutableParagraphStyle *paragraphStyle = [NSMutableParagraphStyle new];
    paragraphStyle.lineSpacing = 3;// 字体的行间距
    NSDictionary *attributesForAll = @{
                                       NSFontAttributeName:[UIFont systemFontOfSize:14.0],
                                       NSForegroundColorAttributeName:UIColor.headlineText,
                                       NSParagraphStyleAttributeName:paragraphStyle
                                       };
    NSString *praiseStr = self.content;
    NSString *praiseInfo = self.content;
    if (self.isVideo) {
        praiseInfo = [NSString stringWithFormat:@"<视频> %@", praiseStr];
    }
    NSMutableAttributedString *attrStr = [Utility exchangeString:@"<视频>" withText:praiseInfo imageName:@"home_video_icon"]; //dynamic_love_blue
    [attrStr addAttributes:attributesForAll range:NSMakeRange(0, attrStr.length)];
    NSRange darkRange =[attrStr.string rangeOfString:praiseStr];
    [attrStr addAttributes:attributesForStr range:darkRange];
    return attrStr;
}
@end
