//
//  ALHomeAleartView.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/12/2.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALHomeAleartView.h"
#import "ALCreateTopicController.h"

@interface ALHomeAleartView ()

@property (nonatomic, strong) NSArray <NSArray *>*imgAndTitleArr;

@property (nonatomic, strong) UIButton *cancelBtn;

@property (nonatomic, strong) NSMutableArray *addArray;

@end

@implementation ALHomeAleartView

- (instancetype)initWithFrame:(CGRect)frame imgAndTitle:(NSArray <NSArray *>*)imgAndTitle
{
    if (self = [super initWithFrame:frame]) {
        
        self.backgroundColor = [UIColor colorWithRed:1 green:1 blue:1 alpha:0.95];
        
        self.imgAndTitleArr = imgAndTitle;
        
        [self setUI];
        
    }
    return self;
}

- (void)setUI
{
    //图片尺寸
    CGSize imgSize = CGSizeMake(65, 65);
    //间距
    CGFloat margin = (MAINSCREEN_WIDTH - self.imgAndTitleArr.count*imgSize.width) /  (self.imgAndTitleArr.count + 1);
    
    [self.imgAndTitleArr enumerateObjectsUsingBlock:^(NSArray * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        
        UIImageView *imageView = [[UIImageView alloc]initWithImage:[UIImage imageNamed:obj.firstObject]];
        imageView.userInteractionEnabled = YES;
        imageView.tag = idx;
        UITapGestureRecognizer *gesture = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(imageViewClick:)];
        [imageView addGestureRecognizer:gesture];
        
        GMLabel *label = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:14];
        label.text = obj.lastObject;
        
        [self addSubview:label];
        [self addSubview:imageView];
        
        [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(imgSize);
            make.bottom.equalTo(self.mas_bottom).offset(-146);
            make.left.equalTo(self.mas_left).offset(margin * (idx + 1) + idx * imgSize.width);
        }];
        [label mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(imageView.mas_centerX);
            make.top.equalTo(imageView.mas_bottom).offset(12);
        }];
    }];
    
    [self addSubview:self.cancelBtn];
    [self.cancelBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(20, 20));
        make.centerX.equalTo(self.mas_centerX);
        make.bottom.equalTo(self.mas_bottom).offset(-30);
    }];
    
}

- (void)imageViewClick:(UIGestureRecognizer *)gesture
{
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    switch (gesture.view.tag) {
        case 0://发帖
        {
            if ([self.delegate respondsToSelector:@selector(clickWhitchMethod:)]) {
                [self.delegate clickWhitchMethod:ClickLeftPost];
            }
            [self hide];
            ALCreateTopicController *controller = [[ALCreateTopicController alloc] initWithComeInType:(FromWhereComeInCreat) from:@"home_click_create_topic"];
            [AppDelegate.navigation pushViewController:controller animated:YES];
        }
            break;
        case 1://打卡
        {
            if ([self.delegate respondsToSelector:@selector(clickWhitchMethod:)]) {
                [self.delegate clickWhitchMethod:ClickRightCard];
            }
            ALCreateTopicController *controller = [[ALCreateTopicController alloc] initWithComeInType:(FromWhereComeInCard) from:@"home_clockin"];
            [AppDelegate.navigation pushViewController:controller animated:YES];
        }
            break;
        default:
            break;
    }
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self hide];
}

- (void)cancelBtnClickMethod
{
    [self hide];
}

- (void)showToView:(UIView *)superView
{
    [superView addSubview:self];
    self.top = 0;
    self.alpha = 0;
    [UIView animateWithDuration:0.25 animations:^{
        self.alpha = 1;
    }];
}

- (void)hide
{
    self.alpha = 1;
    [UIView animateWithDuration:0.25 animations:^{
        self.alpha = 0;
        
    } completion:^(BOOL finished) {
        [self removeFromSuperview];
    }];
}

- (NSArray *)imgAndTitleArr
{
    if (!_imgAndTitleArr) {
        _imgAndTitleArr = [[NSArray alloc]init];
    }
    return _imgAndTitleArr;
}

- (UIButton *)cancelBtn
{
    if (!_cancelBtn) {
        _cancelBtn = [UIButton buttonWithType:(UIButtonTypeCustom)];
        [_cancelBtn setImage:[UIImage imageNamed:@"home_hide"] forState:(UIControlStateNormal)];
        [_cancelBtn addTarget:self action:@selector(cancelBtnClickMethod) forControlEvents:(UIControlEventTouchUpInside)];
    }
    return _cancelBtn;
}

- (NSMutableArray *)addArray
{
    if (!_addArray) {
        _addArray = [NSMutableArray arrayWithCapacity:1];
    }
    return _addArray;
}
@end
