//
//  ALHomeOperationCardCell.m
//  GMAlpha
//
//  Created by zhb on 2018/11/16.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALHomeOperationCardCell.h"
@interface ALHomeOperationCardCell ()
@property (nonatomic, strong) UIImageView *imageView;
@property (nonatomic, strong) UIImage *defaultImage;
@end

@implementation ALHomeOperationCardCell

- (void)setCardObj:(ALHomeOperationObject *)cardObj {
    if (cardObj == nil) return;
    _cardObj = cardObj;
    NSString *imgUrl = cardObj.image.url;
    [self.imageView sd_setImageWithURL:[NSURL URLWithString:imgUrl] placeholderImage:self.defaultImage];
}


#pragma mark - life
- (void)setup {
    [super setup];
    self.backgroundColor = UIColor.grayColor;
    self.layer.cornerRadius = 5;
    self.layer.masksToBounds = YES;
    [self.contentView addSubview:self.imageView];
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.mas_equalTo(0);
    }];
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedMe:)];
    [self addGestureRecognizer:tap];
}

#pragma mark - 事件
- (void)clickedMe:(UITapGestureRecognizer *)tap {
    if ([self.delegate respondsToSelector:@selector(operationCardCellDidSelected:)]) {
        [self.delegate operationCardCellDidSelected:self];
    }
}

#pragma mark - getter
- (UIImageView *)imageView {
    if (!_imageView) {
        _imageView = [[UIImageView alloc] init];
        _imageView.userInteractionEnabled = YES;
    }
    return _imageView;
}

- (UIImage *)defaultImage {
    if (_defaultImage == nil) {
        _defaultImage = [UIImage imageWithColor:RGBCOLOR_HEX(0xF4F3F8)];
    }
    return _defaultImage;
}


@end
