//
//  ALHomeTopicCardCell.h
//  GMAlpha
//
//  Created by zhb on 2018/11/16.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALHomeTopicCardObject.h"

@protocol ALHomeTopicCardCellDelegate;
@interface ALHomeTopicCardCell : GMCollectionViewCell
/** 图片View */
@property (nonatomic, strong) UIImageView *imageView;
/** 点赞Button */
@property (nonatomic, strong) GMButton *voteButton;
/** 点赞数量Label */
@property (nonatomic, strong) UILabel *voteNumLabel;
/**  */
@property (nonatomic, strong) UIImageView *videoImageView;
/** 主题文字Label */
@property (nonatomic, strong) UILabel *textLabel;
/** 用户头像ImageView */
@property (nonatomic, strong) UIImageView *userImageView;;
/** 用户名Label */
@property (nonatomic, strong) UILabel *userNameLabel;

@property (nonatomic, strong) NSIndexPath *indexPath;

@property (nonatomic, weak) id<ALHomeTopicCardCellDelegate> delegate;
/** 赋值数据 */
@property (nonatomic, strong) ALHomeTopicCardObject *cardObj;
+ (CGFloat)textTopMargin;
+ (CGFloat)textLeftMargin;
+ (CGFloat)textRightMargin;
+ (CGFloat)lineTopMargin;
+ (CGFloat)lineHeight;
+ (CGFloat)groupHeight;
@end

/** delegateProtocol */
@protocol ALHomeTopicCardCellDelegate <NSObject>
/** delegate  : 点赞
 *  voteString:埋点使用
 */
- (void)homeTopicCardCellDidVote:(ALHomeTopicCardCell *)cell voteString:(NSString *)voteString;
/** delegate : 作者 或 组信息 */
- (void)homeTopicCardCellClickedPortirait:(ALHomeTopicCardCell *)cell;
/** delegate : 帖子信息 */
- (void)homeTopicCardCellClickedTopic:(ALHomeTopicCardCell *)cell;

@end
