//
//  ALHomeTopicCardCell.m
//  GMAlpha
//
//  Created by zhb on 2018/11/16.
//  Copyright © 2018 Gengmei. All rights reserved.
//
/** 帖子卡片 */

#import "ALHomeTopicCardCell.h"
#import "Utility.h"

@interface ALHomeTopicCardCell ()
/** 中间分隔线 */
@property (nonatomic, strong) UIView *midLineView;
/** 底部用户信息区域 */
@property (nonatomic, strong) UIView *userAreaView;

@property (nonatomic, strong) UIImageView *arrowImgView;;

/** 帖子信息区域 */
@property (nonatomic, strong) UIView *topicAreaView;

@property (nonatomic, strong) UIImage *defTopicImage;
@property (nonatomic, strong) UIImage *defUserImage;
@property (nonatomic, strong) MASConstraint *textLabelTop;
@property (nonatomic, strong) MASConstraint *textLabelBottom;
@end

@implementation ALHomeTopicCardCell

- (void)setCardObj:(ALHomeTopicCardObject *)cardObj {
    if (cardObj == nil) return;
    _cardObj = cardObj;
    //1.帖子图片
    [self.imageView sd_setImageWithURL:[NSURL URLWithString:cardObj.image.url] placeholderImage:self.defTopicImage];
    //2.赞
    self.voteButton.selected = cardObj.isVote;
    self.voteNumLabel.text = [self getVoteNumString];
    //3.用户
    [self.userImageView sd_setImageWithURL:[NSURL URLWithString:cardObj.portrait.icon] placeholderImage:self.defUserImage];
    self.userNameLabel.text = cardObj.portrait.name;
    self.textLabel.attributedText = cardObj.attrContent;
    if (cardObj.attrContent == nil) {
        self.textLabel.hidden = YES;
        self.midLineView.hidden = YES;
        self.textLabelTop.offset(0);
        self.textLabelBottom.mas_equalTo(0);
    }else {
        self.textLabel.hidden = NO;
        self.midLineView.hidden = NO;
        self.textLabelTop.offset([ALHomeTopicCardCell textTopMargin]);
        self.textLabelBottom.mas_equalTo(-[ALHomeTopicCardCell lineTopMargin]);
    }
}


#pragma mark - life cycle
- (void)setup {
    [super setup];
    self.backgroundColor = UIColor.whiteColor;
    self.layer.cornerRadius = 5;
    self.layer.masksToBounds = YES;
    [self.contentView addSubview:self.topicAreaView];
    [self.topicAreaView addSubview:self.imageView];
    [self.topicAreaView addSubview:self.voteButton];
    [self.topicAreaView addSubview:self.voteNumLabel];
    [self.topicAreaView addSubview:self.textLabel];
    [self.contentView addSubview:self.midLineView];
    [self.contentView addSubview:self.userAreaView];
    [self.userAreaView addSubview:self.userImageView];
    [self.userAreaView addSubview:self.userNameLabel];
    [self.userAreaView addSubview:self.arrowImgView];
    
    [self addSubViewConstraints];
}


- (void)addSubViewConstraints {
    
    [self.topicAreaView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.contentView).insets(UIEdgeInsetsMake(0, 0, ([ALHomeTopicCardCell groupHeight] + [ALHomeTopicCardCell lineHeight]), 0));
    }];
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.mas_equalTo(0);
        make.width.equalTo(self.contentView);
    }];
    [self.voteNumLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.imageView.mas_bottom).offset(-8);
        make.height.mas_equalTo(9);
        make.centerX.equalTo(self.voteButton);
    }];

    [self.voteButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.voteNumLabel.mas_top).offset(1);
        make.right.mas_equalTo(-10);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];

    [self.textLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        self.textLabelTop = make.top.equalTo(self.imageView.mas_bottom).offset([ALHomeTopicCardCell textTopMargin]);
        make.left.mas_equalTo([ALHomeTopicCardCell textLeftMargin]);
        make.right.mas_equalTo(-[ALHomeTopicCardCell textRightMargin]);
        self.textLabelBottom =  make.bottom.mas_equalTo(-[ALHomeTopicCardCell lineTopMargin]);
        make.height.mas_greaterThanOrEqualTo(0);
    }];

    [self.midLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.topicAreaView.mas_bottom);
        make.left.mas_equalTo(10);
        make.right.mas_equalTo(-10);
        make.height.mas_equalTo([ALHomeTopicCardCell lineHeight]);
    }];

    [self.userAreaView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.midLineView.mas_bottom);
        make.left.right.equalTo(self.contentView);
        make.height.mas_equalTo([ALHomeTopicCardCell groupHeight]);
        make.bottom.equalTo(self.contentView);
    }];

    [self.userImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(17, 17));
        make.left.mas_equalTo(10);
        make.centerY.equalTo(self.userAreaView);
    }];

    [self.userNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.userImageView.mas_right).offset(10);
        make.top.bottom.equalTo(self.userAreaView);
        make.right.equalTo(self.userAreaView.mas_right).offset(-28);
    }];

    [self.arrowImgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(6, 8));
        make.centerY.mas_offset(0);
        make.right.mas_equalTo(-10);
    }];
}

#pragma mark - 事件
/** action: 💕点赞 */
- (void)clickedVoteButton:(UIButton *)sender
{
    //用户权限
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    NSString *voteString = @"do";
    if (sender.isSelected) {//取消关注
        voteString = @"undo";
        [self requestCancelVote];
        self.cardObj.isVote = NO;
        self.cardObj.voteNum = (self.cardObj.voteNum - 1);
        self.voteButton.selected = NO;
        self.voteNumLabel.text = [self getVoteNumString];
    }else {//关注
        voteString = @"do";
        [self requestAddVote];
        self.cardObj.isVote = YES;
        self.cardObj.voteNum = (self.cardObj.voteNum + 1);
        self.voteButton.selected = YES;
        self.voteNumLabel.text = [self getVoteNumString];
    }
    // TODO: 考虑是否还要代理.
    if ([self.delegate respondsToSelector:@selector(homeTopicCardCellDidVote: voteString:)]) {
        [self.delegate homeTopicCardCellDidVote:self voteString:voteString];
    }
}
/** action : 帖子 */
- (void)clickedTopicAreaView:(UITapGestureRecognizer *)tag {
    if ([self.delegate respondsToSelector:@selector(homeTopicCardCellClickedTopic:)]) {
        [self.delegate homeTopicCardCellClickedTopic:self];
    }
}

/** action : 作者 或 组信息 */
- (void)clickedUserAreaView:(UITapGestureRecognizer *)tag {
    if ([self.delegate respondsToSelector:@selector(homeTopicCardCellClickedPortirait:)]) {
        [self.delegate homeTopicCardCellClickedPortirait:self];
    }
}

#pragma mark - 网络
/** rq 点赞 */
- (void)requestAddVote
{
    NSDictionary *params = @{
                             @"type": @"0",
                             @"id": @(self.cardObj.topicId)
                             };
    
    [GMNetworking requestOCWithApi:API_V1_LIKE method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
    }];
}

/** rq 取消点赞 */
- (void)requestCancelVote
{
    
    NSDictionary *params = @{
                             @"type": @"0",
                             @"id": @(self.cardObj.topicId)
                             };
    
    [GMNetworking requestOCWithApi:API_V1_LIKE_CANCEL method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
    }];
}

#pragma mark - 私有方法
- (NSString *)getVoteNumString {
    NSString *result = @"赞";
    NSInteger voteNum = self.cardObj.voteNum;
    //策略
    if (voteNum <= 0) {
        self.voteNumLabel.hidden = NO;
        return result;
    }
    self.voteNumLabel.hidden = NO;
    if (voteNum <= 999) {
        result = [NSString stringWithFormat:@"%ld", (long)voteNum];
        return result;
    }
    if (voteNum <= 99999) {
        result = [NSString stringWithFormat:@"%.1lfk", (voteNum * 1.0 / 1000.0)];
        return result;
    }
    
    result = [NSString stringWithFormat:@"%.1lfw", (voteNum * 1.0 / 10000.0)];
    return result;
}

#pragma mark - getters and setters
- (UIView *)topicAreaView {
    if (!_topicAreaView) {
        _topicAreaView = [[UIView alloc] init];
        _topicAreaView.backgroundColor = UIColor.whiteColor;
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedTopicAreaView:)];
        [_topicAreaView addGestureRecognizer:tap];
    }
    return _topicAreaView;
}

- (UIImageView *)imageView {
    if (!_imageView) {
        _imageView = [[UIImageView alloc] init];
        _imageView.contentMode = UIViewContentModeScaleToFill;
        _imageView.userInteractionEnabled = YES;
//        [_imageView setContentCompressionResistancePriority:1000 forAxis:1];

    }
    return _imageView;
}
- (GMButton *)voteButton{
    if (_voteButton == nil) {
        _voteButton = [[GMButton alloc] init];
        _voteButton.enableAdaptive = YES;
        [_voteButton setImage:[UIImage imageNamed:@"home_n_vote"] forState:UIControlStateNormal];
        [_voteButton setImage:[UIImage imageNamed:@"home_s_vote"] forState:UIControlStateSelected];
        [_voteButton addTarget:self action:@selector(clickedVoteButton:) forControlEvents:UIControlEventTouchUpInside];
        [_voteButton sizeToFit];
    }
    return _voteButton;
}
- (UILabel *)voteNumLabel{
    if (_voteNumLabel == nil) {
        _voteNumLabel = [[UILabel alloc] init];
        _voteNumLabel.textColor = UIColor.whiteColor;
        _voteNumLabel.font = [UIFont gmFont:9];
        _voteNumLabel.text = @"赞";
    }
    return _voteNumLabel;
}
- (UIImageView *)videoImageView{
    if (_videoImageView == nil) {
        _videoImageView = [[UIImageView alloc] init];
    }
    return _videoImageView;
}
- (UILabel *)textLabel{
    if (_textLabel == nil) {
        _textLabel = [[UILabel alloc] init];
        _textLabel.numberOfLines = 2;
        _textLabel.font = [UIFont gmFont:14];
        [_textLabel setContentHuggingPriority:1000 forAxis:1];
        [_textLabel setContentCompressionResistancePriority:1000 forAxis:1];
    }
    return _textLabel;
}

- (UIView *)midLineView {
    if (_midLineView == nil) {
        _midLineView = [[UIView alloc] init];
        _midLineView.backgroundColor = [UIColor colorWithHexString:@"E5E5E5"];
    }
    return _midLineView;
}

- (UIView *)userAreaView {
    if (_userAreaView == nil) {
        _userAreaView = [[UIView alloc] init];
        _userAreaView.backgroundColor = UIColor.whiteColor;
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickedUserAreaView:)];
        [_userAreaView addGestureRecognizer:tap];
    }
    return _userAreaView;
}

- (UIImageView *)userImageView{
    if (_userImageView == nil) {
        _userImageView = [[UIImageView alloc] init];
        _userImageView.layer.cornerRadius = 8.5;
        _userImageView.layer.masksToBounds = YES;
        _userImageView.image = [UIImage imageNamed:@"user_setter_default_icon_new"];
    }
    return _userImageView;
}

- (UIImageView *)arrowImgView{
    if (_arrowImgView == nil) {
        _arrowImgView = [[UIImageView alloc] init];
        _arrowImgView.image = [UIImage imageNamed:@"home_right_arrow"];
    }
    return _arrowImgView;
}

- (UILabel *)userNameLabel{
    if (_userNameLabel == nil) {
        _userNameLabel = [[UILabel alloc] init];
        _userNameLabel.textColor = [UIColor colorWithHexString:@"666666"];
        _userNameLabel.font = [UIFont gmFont:11];
//        _userNameLabel.text = @"坤坤粉丝后援会";
    }
    return _userNameLabel;
}

- (UIImage *)defTopicImage {
    if (_defTopicImage == nil) {
        _defTopicImage = [UIImage imageWithColor:RGBCOLOR_HEX(0xF4F3F8)];
    }
    return _defTopicImage;
}
- (UIImage *)defUserImage {
    if (_defUserImage == nil) {
        _defUserImage = [UIImage imageNamed:@"user_setter_default_icon_new"];
    }
    return _defUserImage;
}

+ (CGFloat)textTopMargin {
    return 10;
}
+ (CGFloat)textLeftMargin {
    return 10;
}
+ (CGFloat)textRightMargin {
    return 10;
}
+ (CGFloat)lineTopMargin {
    return 10;
}
+ (CGFloat)lineHeight {
    return 1.0 / UIScreen.mainScreen.scale;
}
+ (CGFloat)groupHeight {
    return 38;
}

+ (NSDictionary<NSAttributedStringKey, id> *)textAttrDict {
    return @{
             NSFontAttributeName:[UIFont gmFont:14]
             
             };
    
}
@end
