//
//  ALWaterFlowLayout.h
//  collectionView
//
//  Created by ioszhb on 2018/12/3.
//  Copyright © 2018 张波. All rights reserved.
//

#import <UIKit/UIKit.h>
@protocol ALWaterFlowLayoutDelegate;

@interface ALWaterFlowLayout : UICollectionViewFlowLayout
/** delegate*/
@property (nonatomic, weak) id<ALWaterFlowLayoutDelegate> delegate;
@property (nonatomic, assign, readonly) CGFloat itemWidth;

- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;
- (instancetype)initWithDelegate:(id<ALWaterFlowLayoutDelegate>)delegate;
@end


@protocol ALWaterFlowLayoutDelegate <NSObject>
@required
/** cell的高度 */
- (CGFloat)waterFlowLayout:(ALWaterFlowLayout *)waterFlowLayout rowHeightAtIndexPath:(NSIndexPath *)indexPath;
/** 头视图Size */
-(CGSize )waterFlowLayout:(ALWaterFlowLayout *)waterFlowLayout sizeForHeaderViewInSection:(NSInteger)section;
/** 脚视图Size */
-(CGSize )waterFlowLayout:(ALWaterFlowLayout *)waterFlowLayout sizeForFooterViewInSection:(NSInteger)section;
@optional //以下都有默认值
/** 列数*/
-(CGFloat)columnCountInWaterFlowLayout:(ALWaterFlowLayout *)waterFlowLayout;
/** 列间距*/
-(CGFloat)columnMarginInWaterFlowLayout:(ALWaterFlowLayout *)waterFlowLayout;
/** 行间距*/
-(CGFloat)rowMarginInWaterFlowLayout:(ALWaterFlowLayout *)waterFlowLayout;
/** 边缘之间的间距*/
-(UIEdgeInsets)edgeInsetInWaterFlowLayout:(ALWaterFlowLayout *)waterFlowLayout;
@end
