//
//  GMTabBar.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/5.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "GMTabBar.h"
#import "GMConst.h"
#import "GMTabBarIconManager.h"
#import "AppDelegate+ViewControl.h"
#import "AppDelegate.h"

@interface GMTabBar ()

/** 上一次点击的按钮 */
@property (nonatomic, weak) UIControl *previousClickedTabBarButton;
/** 添加按钮的数组 */
@property (nonatomic, strong) NSMutableArray *btnArray;

@end

@implementation GMTabBar

- (instancetype)init
{
    if (self = [super init])
    {
        [self setUI];
    }
    return self;
}

- (void)setUI
{
    NSArray *titleArray = @[@"首页",@"小组",@"",@"消息",@"我"];
    
    for (int i = 0; i<5 ; i++)
    {
        UIButton *button = [UIButton buttonWithType:(UIButtonTypeCustom)];
        UIImageView *imageV = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"tabbar_backImg"]];
        imageV.tag = 2000;
        [button addSubview:imageV];
        [imageV mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(button.mas_centerX);
            make.size.mas_equalTo(CGSizeMake(36.5, 10.5));
            make.top.equalTo(button.mas_centerY);
        }];
        
        UIImageView *backImgV = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"tabbar_center_icon"]];
        [button addSubview:backImgV];
        backImgV.tag = 3000;
        [backImgV mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(button.mas_centerX);
            make.size.mas_equalTo(CGSizeMake(52, 34));
            make.centerY.equalTo(button.mas_centerY);
        }];
        
        [button setTitleColor:UIColor.headlineText forState:(UIControlStateNormal)];
        [button sizeToFit];
        button.enabled = NO;
        if (i == 2)
        {
            [imageV removeFromSuperview];
        }
        else
        {
            [button setTitle:titleArray[i] forState:(UIControlStateNormal)];
            [backImgV removeFromSuperview];
        }
        if (i == 0)
        {
            imageV.hidden = NO;
            [button.titleLabel setFont:[UIFont boldSystemFontOfSize:18]];
        }
        else
        {
            imageV.hidden = YES;
            [button.titleLabel setFont:[UIFont systemFontOfSize:16]];
        }

        [self addSubview:button];
        [self.btnArray addObject:button];
    }
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    // 跳转tabBarButton位置
    int i = 0;
    // 私有类:打印出来有个类,但是敲出来没有,说明这个类是系统私有类
    // 遍历子控件 调整布局
    for (UIControl *tabBarButton in self.subviews) {
        tabBarButton.tag = 1000+i;

        if ([tabBarButton isKindOfClass:NSClassFromString(@"UITabBarButton")]) {
            if (i == 0 && self.previousClickedTabBarButton == nil) {
                self.previousClickedTabBarButton = tabBarButton;
            }
            UIButton *btn = self.btnArray[i];
            btn.frame = tabBarButton.frame;
            btn.tag = tabBarButton.tag;
            i++;
            // 监听点击
            [tabBarButton addTarget:self action:@selector(tabBarButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        }
    }
}
//
///**
// *  tabBarButton的点击
// */

- (void)setTabbarButton:(NSInteger)index
{
    UIControl *tabBarButton = [[UIControl alloc]init];
    
    tabBarButton.tag = index + 1000;

    [self tabBarButtonClick:tabBarButton];
}

- (void)tabBarButtonClick:(UIControl *)tabBarButton
{
    
    if (tabBarButton.tag - 1000 == 4 && [GMLoginManager shareInstance].isVisitor) {
        return;
    }
    
    UIButton *btn = self.btnArray[tabBarButton.tag - 1000];
    [self.btnArray enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        UIButton *button = obj;
        if (button.tag == tabBarButton.tag)
        {
            [button setTitleColor:UIColor.headlineText forState:(UIControlStateNormal)];
            [button.titleLabel setFont:[UIFont boldSystemFontOfSize:18]];
            for (UIControl *control in button.subviews) {
                if ([control isKindOfClass:[UIImageView class]]) {
                    control.hidden = NO;
                }
                else
                {
                    if ([control isKindOfClass:[UILabel class]])
                    {
                        control.hidden = NO;
                    }else
                    {
                        control.hidden = YES;
                    }
                    
                }
            }
        }
        else
        {
            [button setTitleColor:UIColor.headlineText forState:(UIControlStateNormal)];
            [button.titleLabel setFont:[UIFont systemFontOfSize:16]];
            for (UIControl *control in button.subviews) {
                if ([control isKindOfClass:[UIImageView class]] && control.tag == 2000) {
                    control.hidden = YES;
                }
                else
                {
                    control.hidden = NO;
                }
            }
        }
    }];
    CAKeyframeAnimation *scaleAnimation = [[CAKeyframeAnimation alloc] init];
    scaleAnimation.keyPath = @"transform.scale";
    scaleAnimation.values = @[@1.0, @1.4, @0.9, @1.15, @0.95, @1.02, @1.0];
    scaleAnimation.duration = 1.0;
    scaleAnimation.calculationMode = kCAAnimationCubic;
    [btn.layer addAnimation:scaleAnimation forKey:@"scaleAniamtion"];

    if (self.previousClickedTabBarButton == tabBarButton) {
        // 发出通知，告知外界tabBarButton被重复点击了
        [[NSNotificationCenter defaultCenter] postNotificationName:GMTabBarButtonDidRepeatClickNotification object:nil];
    }
    self.previousClickedTabBarButton = tabBarButton;

}
- (NSMutableArray *)btnArray
{
    if (!_btnArray) {
        _btnArray = [NSMutableArray arrayWithCapacity:5];
    }
    return _btnArray;
}
@end
