//
//  ALSelectCountryController.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/23.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALSelectCountryController.h"
#import "ALSelectCountryViewModel.h"
#import "ALSelectCountryCell.h"

@interface ALSelectCountryController ()

@property (nonatomic, strong) ALSelectCountryViewModel *viewModel;

@end

@implementation ALSelectCountryController
#pragma mark - life cycle
- (void)initController
{
    [super initController];
    self.viewModel = [[ALSelectCountryViewModel alloc] init];
//    self.immediateLoad = NO;
    _needFooterRefresh = NO;
    _needHeaderRefresh = NO;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self setNav];
    [self setUI];
    [self setLayout];
}

#pragma mark--baseMethod

- (void)setNav
{
    self.title = @"选择国家";
}

- (void)setUI
{
    _tableStyle = UITableViewStyleGrouped;
    [_table registerCell:[ALSelectCountryCell class]];
}

- (void)setLayout
{

}

#pragma mark--system delegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.viewModel.dataArray.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    ALSelectCountryObject *countryObject = self.viewModel.dataArray[section];
    
    return countryObject.countries.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ALSelectCountryCell *cell = [_table dequeueCell:[ALSelectCountryCell class] forIndexPath:indexPath];
    ALSelectCountryObject *model = self.viewModel.dataArray[indexPath.section];
    cell.countryObject = model.countries[indexPath.row];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.returnCountryCodeBlock != nil) {
        
        ALSelectCountryObject *model = self.viewModel.dataArray[indexPath.section];
        ALSelectCountryArrayObject *countryObject = model.countries[indexPath.row];
        self.returnCountryCodeBlock(countryObject);
        [self.navigationController popViewControllerAnimated:YES];
    }    
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    GMView *backView = [[GMView alloc]init];
    backView.backgroundColor = UIColor.background;
    
    GMLabel *label = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight fontSize:11];
    ALSelectCountryObject *countryObject = self.viewModel.dataArray[section];
    label.text = countryObject.title;
    
    [backView addSubview:label];
    [label mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(backView.mas_left).offset(15);
        make.centerY.equalTo(backView.mas_centerY);
    }];
    
    return backView;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [ALSelectCountryCell cellHeight];
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 20;
}

/** 右侧的索引 */
- (NSArray<NSString *> *)sectionIndexTitlesForTableView:(UITableView *)tableView
{
    return self.viewModel.idArray;
}
@end
