//
//  ALSelectCountryCell.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/24.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALSelectCountryCell.h"
#import "ALSelectCountryObject.h"

@interface ALSelectCountryCell ()
/** 国家名称 */
@property (nonatomic, strong) GMLabel *nameLabel;

@end

@implementation ALSelectCountryCell

- (void)setup
{
    [super setup];
    [self.contentView addSubview:self.nameLabel];
}

- (void)cellConstraints
{
    [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.contentView.mas_left).offset(15);
        make.centerY.equalTo(self.contentView.mas_centerY);
        make.right.equalTo(self.contentView.mas_right);
        make.height.equalTo(self.contentView.mas_height);
    }];
}

#pragma mark--setter

- (void)setCountryObject:(ALSelectCountryArrayObject *)countryObject
{
    _countryObject = countryObject;
    NSLog(@"%@",countryObject.name);
    self.nameLabel.text = countryObject.name;
}

+ (CGFloat)cellHeight
{
    return 44.0f;
}

#pragma mark--getter

- (GMLabel *)nameLabel
{
    if (!_nameLabel) {
        _nameLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:13];
    }
    return _nameLabel;
}

@end
