//
//  ALSelectCountryViewModel.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/24.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALSelectCountryViewModel.h"
#import "ALSelectCountryObject.h"

@implementation ALSelectCountryViewModel

- (instancetype)init
{
    self = [super init];
    if (self) {
        _remoteUrl = API_SETTING_COUNTRYLIST;
    }
    return self;
}

- (void)buildModelWithRemoteDic:(NSDictionary *)dic{
    if ([dic[@"error"] integerValue] != 0) {
        return;
    }
    [self.idArray removeAllObjects];
    NSArray *contentArray = dic[@"data"];
    [self.dataArray addObjectsFromArray:[ALSelectCountryObject arrayOfModelsFromDictionaries:contentArray error:nil]];
    [self.dataArray enumerateObjectsUsingBlock:^(ALSelectCountryObject *obj, NSUInteger idx, BOOL * _Nonnull stop) {
        [self.idArray addObject:obj.title];
    }];
}

- (NSMutableArray *)idArray
{
    if (!_idArray) {
        _idArray = [NSMutableArray arrayWithCapacity:1];
    }
    return _idArray;
}

@end
