//
//  ALMeCollectionHeader.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/9.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "ALMeCollectionHeader.h"
#import "ALBindPhoneController.h"
#import "ALMeSettingsController.h"
#import "ALMyCenterObject.h"
#import "ALFaceSDK.h"
#import "ALMyCenterViewModel.h"
#import "ALUpLoadManager.h"

@interface ALMeCollectionHeader()<ALMeSettingsControllerDelegate>
/** 发帖数 */
@property (nonatomic, strong) GMLabel *postLabel;
/** 小组数 */
@property (nonatomic, strong) GMLabel *groupLabel;
/** 注册时间 */
//@property (nonatomic, strong) GMLabel *registerLabel;
/** 头像 */
@property (nonatomic, strong) GMImageView *portrait;
/** 头像底图 */
@property (nonatomic, strong) GMImageView *portraitBottom;
/** 中心页名称 */
@property (nonatomic, strong) GMLabel *titleLabel;
/** 设置按钮 */
@property (nonatomic, strong) GMButton *settingButton;
/** 绑定View */
@property (nonatomic, strong) GMView *bindPhone;
/** x图片 */
@property (nonatomic, strong) GMImageView *dissImage;
/** 绑定手机号的文案 */
@property (nonatomic, strong) GMLabel *phoneLabel;
/** 绑定按钮 */
@property (nonatomic, strong) GMButton *goBindPhone;

@property (nonatomic, strong) ALFaceSDK *faceSDK;
/** 顶部导航栏的View,因为要兼容刘海屏幕 */
@property (nonatomic, strong) GMView *topView;
/** 顶部状态栏的view,同样兼容刘海屏幕*/
@property (nonatomic, strong) GMView *statusView;

@property (nonatomic, strong) GMView *borderView;
@end
@implementation ALMeCollectionHeader

/** 是否已经点击了dissImage图片 */
static BOOL _isClick;

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self)
    {
        self.backgroundColor = UIColor.whiteColor;
        [self setUI];
        [self setLayout];
    }
    return self;
}

#pragma mark--click
// 不去绑定的点击事件
- (void)dissMissBindMethod
{
    [UIView animateWithDuration:0.5 animations:^{
        _isClick = YES;
        self.bindPhone.hidden = YES;
    } completion:^(BOOL finished) {
        if ([self.delegate respondsToSelector:@selector(refreshHeaderViewMethod)]) {
            [self.delegate refreshHeaderViewMethod];
        }
    }];
}
// 设置的点击事件
- (void)clickSettings {
    if ([self.delegate respondsToSelector:@selector(clickSetBtnMethod)]) {
        [self.delegate clickSetBtnMethod];
    }
    ALMeSettingsController *vc = [[ALMeSettingsController alloc] init];
    vc.delegate = self;
    vc.centerModel = self.modelObject;
    [AppDelegate.navigation pushViewController:vc animated:YES];
}
// 去绑定的点击事件
- (void)bindPhoneAction {
    ALBindPhoneController *controller = [[ALBindPhoneController alloc] init];
    controller.removeTipBlock = ^{
        self.bindPhone.hidden = YES;
    };
    [AppDelegate.navigation pushViewController:controller animated:YES];
}

#pragma mark--setter Method

+ (CGSize)headerHeight:(ALMyCenterObject *)modelObject
{
    //绑定手机号的view的高度
    CGFloat bindPhoneHeight;
    //已经绑定
    if (modelObject.userInfo.isBindPhone == YES)
    {
        bindPhoneHeight = 0.0f;
    }
    else
    {
        if (_isClick) {
            bindPhoneHeight = 0.0f;
        }else{
            bindPhoneHeight = 40.0f;
        }
    }
    //自己不显示推荐关注
    CGFloat height = 136 + OCNavigationBar.barHeight + bindPhoneHeight;
    
    return CGSizeMake(MAINSCREEN_WIDTH, height);
}

- (void)setModelObject:(ALMyCenterObject *)modelObject
{
    _modelObject = modelObject;
    //判断是否已经绑定过手机号，绑定过就隐藏
    
    if (_isClick)
    {
        self.bindPhone.hidden = YES;
    }
    else
    {
        if (modelObject.userInfo.isBindPhone == YES)
        {
            self.bindPhone.hidden = YES;
        }
        else
        {
            self.bindPhone.hidden = NO;
        }
    }
    
    //界面赋值
    self.postLabel.text = [NSString stringWithFormat:@"发帖 %zd",modelObject.userInfo.topicNum];
    NSMutableAttributedString *postAttributedText = [[NSMutableAttributedString alloc] initWithString:self.postLabel.text];
    NSRange range1 =[self.postLabel.text rangeOfString:[NSString stringWithFormat:@"%zd",modelObject.userInfo.topicNum]];
    [postAttributedText addAttribute:NSForegroundColorAttributeName value:UIColor.bodyText range:range1];
    self.postLabel.attributedText = postAttributedText;
    
    self.groupLabel.text = [NSString stringWithFormat:@"小组 %zd",modelObject.userInfo.groupNum];
    NSRange range2 =[self.groupLabel.text rangeOfString:[NSString stringWithFormat:@"%zd",modelObject.userInfo.groupNum]];
    NSMutableAttributedString *groupAttributedText = [[NSMutableAttributedString alloc] initWithString:self.groupLabel.text];
    [groupAttributedText addAttribute:NSForegroundColorAttributeName value:UIColor.bodyText range:range2];
    self.groupLabel.attributedText = groupAttributedText;
    
    [self.portrait sd_setImageWithURL:[NSURL URLWithString:modelObject.userInfo.icon]placeholderImage:[UIImage imageNamed:@"user_setter_default_icon_new"]];
    //中心页名称
    self.titleLabel.text = modelObject.userInfo.name;
}

//时间戳转时间
- (NSString *)dateString:(NSNumber *)time
{
    NSTimeInterval interval =[time doubleValue];
    NSDate *date = [NSDate dateWithTimeIntervalSince1970:interval];
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateFormat:@"yyyy.MM.dd"];
    NSString *dateString = [formatter stringFromDate: date];
    return dateString;
}

#pragma mark--delegate
- (void)refreshUserInfoMethod
{
    
    WMUser *user = [GMLoginManager shareInstance].user;
    
    [self.portrait sd_setImageWithURL:[NSURL URLWithString:user.portrait]placeholderImage:[UIImage imageNamed:@"user_setter_default_icon_new"]];
    //中心页名称
    self.titleLabel.text = SafeString(user.nickName);
}

#pragma mark--setUI Method

- (void)setUI
{
    [self addSubview:self.statusView];
    [self addSubview:self.topView];
    [self.topView addSubview:self.titleLabel];
    [self.topView addSubview:self.settingButton];
    [self addSubview:self.portraitBottom];
    [self addSubview:self.portrait];
    [self addSubview:self.postLabel];
    [self addSubview:self.groupLabel];
    [self addSubview:self.bindPhone];
    [self.bindPhone addSubview:self.dissImage];
    [self.bindPhone addSubview:self.phoneLabel];
    [self.bindPhone addSubview:self.goBindPhone];
}


- (void)setLayout
{
    [self.statusView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.equalTo(self);
        make.height.mas_equalTo(OCNavigationBar.statusBarHeight);
    }];
    [self.topView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.statusView.mas_bottom);
        make.left.right.equalTo(self);
        make.height.mas_equalTo(44);
    }];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.topView.mas_centerX);
        make.bottom.equalTo(self.topView.mas_bottom);
        make.height.mas_equalTo(19);
    }];
    
    [self.settingButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-15);
        make.centerY.equalTo(self.titleLabel.mas_centerY);
        make.size.mas_equalTo(CGSizeMake(20, 20));
    }];
    [self.portraitBottom mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(25);
        make.size.mas_equalTo(CGSizeMake(85, 85));
        make.top.equalTo(self.topView.mas_bottom).offset(28);
    }];
    [self.portrait mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(82, 82));
        make.centerX.equalTo(self.portraitBottom.mas_centerX);
        make.centerY.equalTo(self.portraitBottom.mas_centerY);
//        make.left.mas_equalTo(25);
//        make.top.equalTo(self.topView.mas_bottom).offset(28);
    }];
    
    [self.postLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.portrait.mas_centerY);
        make.left.equalTo(self.portrait.mas_right).offset(10);
    }];
    
    [self.groupLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.portrait.mas_centerY);
        make.left.equalTo(self.postLabel.mas_right).offset(10);
    }];

    [self.bindPhone mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.mas_top).offset(136+OCNavigationBar.barHeight);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(40);
    }];
    
    [self.dissImage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.left.mas_equalTo(10);
    }];
    
    [self.phoneLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.left.equalTo(self.dissImage.mas_right).offset(5);
    }];
    
    [self.goBindPhone mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.right.mas_equalTo(-20);
        make.height.mas_equalTo(23);
        make.width.mas_equalTo(60);
    }];
}

#pragma mark--getter Method

- (GMLabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:21];
        _titleLabel.font = [UIFont systemFontOfSize:18];
    }
    return _titleLabel;
}

- (GMButton *)settingButton
{
    if (!_settingButton) {
        _settingButton = [GMButton buttonWithType:UIButtonTypeCustom];
        [_settingButton addTarget:self action:@selector(clickSettings) forControlEvents:UIControlEventTouchUpInside];
        [_settingButton setBackgroundImage:[UIImage  imageNamed:@"me_setting"] forState:UIControlStateNormal];
    }
    return _settingButton;
}

- (GMImageView *)portrait
{
    if (!_portrait) {
        _portrait = [[GMImageView alloc] init];
        _portrait.layer.masksToBounds = YES;
        _portrait.layer.cornerRadius = 42.5;
        _portrait.userInteractionEnabled = YES;
        _portrait.contentMode = UIViewContentModeScaleAspectFit;
        _portrait.image = [UIImage  imageNamed:@"user_setter_default_icon_new"];
    }
    return _portrait;
}
- (GMImageView *)portraitBottom
{
    if (!_portraitBottom) {
        _portraitBottom = [[GMImageView alloc] init];
        _portraitBottom.image = [UIImage  imageNamed:@"me_icon_back"];
    }
    return _portraitBottom;
}

- (GMLabel *)postLabel
{
    if (!_postLabel) {
        _postLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight fontSize:14];
    }
    return _postLabel;
}

- (GMLabel *)groupLabel
{
    if (!_groupLabel) {
        _groupLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextLight fontSize:14];
    }
    return _groupLabel;
}

- (GMView *)bindPhone
{
    if (!_bindPhone) {
        _bindPhone = [[GMView alloc] init];
        _bindPhone.backgroundColor = RGBCOLOR_HEX(0xD8EFFF);
    }
    return _bindPhone;
}

- (GMImageView *)dissImage
{
    if (!_dissImage) {
        _dissImage = [[GMImageView alloc] init];
        _dissImage.image = [UIImage imageNamed:@"me_phone_diss"];
        _dissImage.userInteractionEnabled = YES;
        UITapGestureRecognizer *tapGest = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(dissMissBindMethod)];
        [_dissImage addGestureRecognizer:tapGest];
    }
    return _dissImage;
}

- (GMLabel *)phoneLabel
{
    if (!_phoneLabel) {
        _phoneLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x0093ff) fontSize:14];
        _phoneLabel.text = @"绑定手机号完善个人信息";
    }
    return _phoneLabel;
}

- (GMButton *)goBindPhone
{
    if (!_goBindPhone) {
        _goBindPhone = [GMButton buttonWithCustomType:GMButtonTypeGreenSemicircle];
        _goBindPhone.titleLabel.font = [UIFont gmFont:12];
        [_goBindPhone addTarget:self action:@selector(bindPhoneAction) forControlEvents:UIControlEventTouchUpInside];
        [_goBindPhone setTitle:@"去绑定" forState:UIControlStateNormal];
        [_goBindPhone setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
        [_goBindPhone setBackgroundColor:RGBCOLOR_HEX(0x0093ff) forState:UIControlStateNormal];
    }
    return _goBindPhone;
}

- (ALFaceSDK *)faceSDK
{
    if (!_faceSDK) {
        _faceSDK = [[ALFaceSDK alloc]init];
    }
    return _faceSDK;
}

- (GMView *)topView
{
    if (!_topView) {
        _topView = [[GMView alloc]init];
    }
    return _topView;
}

- (GMView *)statusView
{
    if (!_statusView) {
        _statusView = [[GMView alloc]init];
    }
    return _statusView;
}

@end


