//
//  ALPersonCollectionHeader.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/12/4.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALPersonCollectionHeader.h"
#import "ALBindPhoneController.h"
#import "ALMeSettingsController.h"
#import "ALMyCenterObject.h"
#import "ALFaceSDK.h"
#import "ALMyCenterViewModel.h"
#import "ALUpLoadManager.h"
#import "ALMeCollectionHeader.h"

@interface ALPersonCuiGengView : GMView

@property (nonatomic, strong) GMButton *cuiGengButton;

@property (nonatomic, strong) GMImageView *rightIcon;
/**  */
@property (nonatomic, strong) ALMyCenterObject *model;

@end

@implementation ALPersonCuiGengView

- (void)setup
{
    [super setup];
    
    [self setUI];
    
    [self setLayout];
}

- (void)setUI
{
    
    [self addSubview:self.cuiGengButton];
    
    [self addSubview:self.rightIcon];
}

- (void)setLayout
{
    [self.cuiGengButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(115, 23));
    }];
    
    [self.rightIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(30, 23));
        make.right.equalTo(self.mas_right);
        make.top.mas_equalTo(0);
    }];
}
/** 催更操作 */
- (void)cuiGengButtonClickMethod:(GMButton *)sender
{
    NSDictionary *params = @{@"id":@(self.model.userInfo.id)};
    [AppDelegate.visibleController showLoading:nil];
    [GMNetworking requestOCWithApi:API_V1_URGE method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
        [AppDelegate.visibleController toast:response.message];
        
        if (response.isSuccess)
        {
            [self.cuiGengButton setTitle:@"今日已催更" forState:(UIControlStateNormal)];
            [self.cuiGengButton setBackgroundColor:[UIColor whiteColor]];
            self.cuiGengButton.layer.borderColor = RGBCOLOR_HEX(0xcccccc).CGColor;
            [self.cuiGengButton setTitleColor:RGBCOLOR_HEX(0xcccccc) forState:(UIControlStateNormal)];
            self.cuiGengButton.userInteractionEnabled = NO;
        }
       
    }];
}

- (void)rightIconMethod
{
//    取消关注
    NSDictionary *params = @{
                             @"type": @"1",
                             @"id": @(self.model.userInfo.id)
                             };
    [AppDelegate.visibleController showLoading:nil];
    [GMNetworking requestOCWithApi:API_V1_CANCEL_FOLLOW method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
        if (response.isSuccess == NO) return;
        //更改view状态
        [[NSNotificationCenter defaultCenter] postNotificationName:CANCEL_FOLLOW_NAME object:nil];
        
    }];
}

- (GMButton *)cuiGengButton
{
    if (!_cuiGengButton) {
        _cuiGengButton = [GMButton buttonWithCustomType:GMButtonTypeGreenRoundCornerBorder];
        _cuiGengButton.layer.borderColor = RGBCOLOR_HEX(0xcccccc).CGColor;
        _cuiGengButton.layer.cornerRadius = 2;
        [_cuiGengButton.titleLabel setFont:[UIFont systemFontOfSize:13]];
        [_cuiGengButton setTitleColor:RGBCOLOR_HEX(0x464646) forState:UIControlStateNormal];
        [_cuiGengButton setTitle:@"催TA打卡" forState:UIControlStateNormal];
        [_cuiGengButton addTarget:self action:@selector(cuiGengButtonClickMethod:) forControlEvents:(UIControlEventTouchUpInside)];
    }
    return _cuiGengButton;
}

- (GMImageView *)rightIcon
{
    if (!_rightIcon) {
        _rightIcon = [[GMImageView alloc] init];
        _rightIcon.image = [UIImage imageNamed:@"me_cui_geng"];
        _rightIcon.userInteractionEnabled = YES;
        UITapGestureRecognizer *gesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(rightIconMethod)];
        [_rightIcon addGestureRecognizer:gesture];
    }
    return _rightIcon;
}

@end


@interface ALPersonCollectionHeader ()

/** 发帖数 */
@property (nonatomic, strong) GMLabel *postLabel;
/** 小组数 */
@property (nonatomic, strong) GMLabel *groupLabel;
/** 头像 */
@property (nonatomic, strong) GMImageView *portrait;
/** 催更view */
@property (nonatomic, strong) ALPersonCuiGengView *cuiGengView;
/** 关注按钮 */
@property (nonatomic, strong) GMButton *followButton;
/** 推荐关注view */
@property (nonatomic, strong) ALRecommendUserView *recommedView;

@property (nonatomic, strong) ALFaceSDK *faceSDK;
/** 头像底图 */
@property (nonatomic, strong) GMImageView *portraitBottom;

@end

@implementation ALPersonCollectionHeader

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self)
    {
        self.backgroundColor = UIColor.whiteColor;
        [self setUI];
        [self setLayout];
    }
    return self;
}
#pragma mark--click
//点击关注
- (void)followButtonClickMethod:(GMButton *)sender
{
    
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    
    NSDictionary *params = @{
                             @"id":@(self.modelObject.userInfo.id),
                             @"type":@(1),
                             };
    __weak __typeof(self)weakSelf = self;
    [AppDelegate.visibleController showLoading:nil];
    [GMNetworking requestOCWithApi:API_V1_FOLLOW method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * response) {
//        NSDictionary *dict = response.data;
        [AppDelegate.visibleController toast:response.message];
        
        if (response.error == 0)
        {
            weakSelf.followButton.hidden = YES;
            weakSelf.cuiGengView.hidden = NO;
            if([weakSelf.delegate respondsToSelector:@selector(refreshHeaderViewMethod)])
            {
                [weakSelf.delegate refreshHeaderViewMethod];
            }
        }
        else
        {
            
        }
    }];
    
}
#pragma mark--setter Method

+ (CGSize)headerHeight:(ALMyCenterObject *)modelObject
{
    CGFloat height = 414 - [ALRecommendUserView recommendUserViewHeight];
    //有值
    if (modelObject.recommendList.count)
    {
        //未关注不展示推荐人信息
        if (modelObject.userInfo.isFollow == NO)
        {
            return CGSizeMake(MAINSCREEN_WIDTH, 136);
        }
        else
        {
            return CGSizeMake(MAINSCREEN_WIDTH, 414);
        }
    }
    else
    {
        return CGSizeMake(MAINSCREEN_WIDTH, 136);
    }
}

- (void)setModelObject:(ALMyCenterObject *)modelObject
{
    _modelObject = modelObject;

    self.cuiGengView.model = modelObject;
    //如果未关注则不展示推荐人信息
    if (modelObject.userInfo.isFollow == NO)
    {
        self.recommedView.hidden = YES;
    }
    else if (modelObject.recommendList.count)
    {
        //有数据再赋值
        self.recommedView.hidden = NO;
        self.recommedView.recommendUserArray = modelObject.recommendList;
    }
    else
    {
        self.recommedView.hidden = YES;
    }
    //如果关注
    if (modelObject.userInfo.isFollow == YES)
    {
        //已经关注
        self.followButton.hidden = YES;
        self.cuiGengView.hidden = NO;
        if (modelObject.userInfo.isUrged == YES)
        {
            self.cuiGengView.cuiGengButton.userInteractionEnabled = NO;
            [self.cuiGengView.cuiGengButton setTitle:@"今日已催更" forState:(UIControlStateNormal)];
            [self.cuiGengView.cuiGengButton setTitleColor:RGBCOLOR_HEX(0xcccccc) forState:(UIControlStateNormal)];
            [self.cuiGengView.cuiGengButton setBackgroundColor:[UIColor whiteColor]];
            self.cuiGengView.cuiGengButton.layer.borderColor = RGBCOLOR_HEX(0xcccccc).CGColor;
        }
        else
        {
            self.cuiGengView.cuiGengButton.userInteractionEnabled = YES;
            [self.cuiGengView.cuiGengButton setTitle:@"催TA打卡" forState:(UIControlStateNormal)];
            [self.cuiGengView.cuiGengButton setTitleColor:[UIColor whiteColor] forState:(UIControlStateNormal)];
            [self.cuiGengView.cuiGengButton setBackgroundColor:RGBCOLOR_HEX(0x0093FF)];
            self.cuiGengView.cuiGengButton.layer.borderColor = RGBCOLOR_HEX(0x0093FF).CGColor;
        }
    }
    else
    {
        self.cuiGengView.hidden = YES;
        self.followButton.hidden = NO;
    }
    //界面赋值
    self.postLabel.text = [NSString stringWithFormat:@"发帖 %zd",modelObject.userInfo.topicNum];
    NSMutableAttributedString *postAttributedText = [[NSMutableAttributedString alloc] initWithString:self.postLabel.text];
    NSRange range1 =[self.postLabel.text rangeOfString:[NSString stringWithFormat:@"%zd",modelObject.userInfo.topicNum]];
    [postAttributedText addAttribute:NSForegroundColorAttributeName value:UIColor.bodyText range:range1];
    self.postLabel.attributedText = postAttributedText;
    
    self.groupLabel.text = [NSString stringWithFormat:@"小组 %zd",modelObject.userInfo.groupNum];
    NSRange range2 =[self.groupLabel.text rangeOfString:[NSString stringWithFormat:@"%zd",modelObject.userInfo.groupNum]];
    NSMutableAttributedString *groupAttributedText = [[NSMutableAttributedString alloc] initWithString:self.groupLabel.text];
    [groupAttributedText addAttribute:NSForegroundColorAttributeName value:UIColor.bodyText range:range2];
    self.groupLabel.attributedText = groupAttributedText;
    
    [self.portrait sd_setImageWithURL:[NSURL URLWithString:modelObject.userInfo.icon] placeholderImage:[UIImage imageNamed:@"user_setter_default_icon_new"]];
    
}
#pragma mark--setUI Method

- (void)setUI
{
    [self addSubview:self.portraitBottom];
    [self addSubview:self.portrait];
    [self addSubview:self.postLabel];
    [self addSubview:self.groupLabel];
    [self addSubview:self.followButton];
    [self addSubview:self.cuiGengView];
    [self addSubview:self.followButton];
    [self addSubview:self.recommedView];
}
- (void)setLayout
{
    [self.portraitBottom mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(25);
        make.top.mas_equalTo(28);
        make.width.mas_equalTo(85);
        make.height.mas_equalTo(85);
    }];
    [self.portrait mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(82, 82));
        make.centerX.equalTo(self.portraitBottom.mas_centerX);
        make.centerY.equalTo(self.portraitBottom.mas_centerY);
    }];
    
    [self.postLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.portrait.mas_centerY).offset(-7);
        make.top.equalTo(self.portrait.mas_top).offset(20);
        make.left.equalTo(self.portrait.mas_right).offset(10);
    }];
    
    [self.groupLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.postLabel.mas_centerY);
        make.left.equalTo(self.postLabel.mas_right).offset(10);
    }];
    [self.cuiGengView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.postLabel.mas_left);
        make.top.equalTo(self.portrait.mas_centerY).offset(7);
        make.size.mas_equalTo(CGSizeMake(150, 23));
    }];
    
    [self.followButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.postLabel.mas_left);
        make.top.equalTo(self.portrait.mas_centerY).offset(7);
        make.size.mas_equalTo(CGSizeMake(115, 23));
    }];

    [self.recommedView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.mas_top).offset(180);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo([ALRecommendUserView recommendUserViewHeight]);
        make.bottom.mas_equalTo(0);
    }];
}

#pragma mark--getter Method

- (GMImageView *)portrait
{
    if (!_portrait) {
        _portrait = [[GMImageView alloc] init];
        _portrait.layer.cornerRadius = 42.5;
        _portrait.layer.masksToBounds = YES;
        _portrait.userInteractionEnabled = YES;
        _portrait.contentMode = UIViewContentModeScaleAspectFit;
        _portrait.image = [UIImage  imageNamed:@"user_setter_default_icon_new"];
    }
    return _portrait;
}

- (GMLabel *)postLabel
{
    if (!_postLabel) {
        _postLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextDark fontSize:14];
    }
    return _postLabel;
}

- (GMLabel *)groupLabel
{
    if (!_groupLabel) {
        _groupLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextDark fontSize:14];
    }
    return _groupLabel;
}

- (ALPersonCuiGengView *)cuiGengView
{
    if (!_cuiGengView) {
        _cuiGengView = [[ALPersonCuiGengView alloc] init];
        _cuiGengView.hidden = YES;
    }
    return _cuiGengView;
}

- (ALRecommendUserView *)recommedView
{
    if (!_recommedView) {
        _recommedView = [[ALRecommendUserView alloc] init];        
    }
    return _recommedView;
}

- (GMButton *)followButton
{
    if(!_followButton){
        _followButton = [GMButton buttonWithCustomType:GMButtonTypeGreenRoundCornerBorder];
        _followButton.layer.borderColor = RGBCOLOR_HEX(0x0093FF).CGColor;
        _followButton.layer.cornerRadius = 2;
        _followButton.titleLabel.font = [UIFont gmFont:13];
        [_followButton setTitle:@"+ 关注" forState:UIControlStateNormal];
        [_followButton setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
        [_followButton setBackgroundColor:RGBCOLOR_HEX(0x0093FF) forState:UIControlStateNormal];
        [_followButton addTarget:self action:@selector(followButtonClickMethod:) forControlEvents:(UIControlEventTouchUpInside)];
        _followButton.hidden = YES;
    }
    return _followButton;
}
- (ALFaceSDK *)faceSDK
{
    if (!_faceSDK) {
        _faceSDK = [[ALFaceSDK alloc]init];
    }
    return _faceSDK;
}
- (GMImageView *)portraitBottom
{
    if (!_portraitBottom) {
        _portraitBottom = [[GMImageView alloc] init];
        _portraitBottom.image = [UIImage  imageNamed:@"me_icon_back"];
    }
    return _portraitBottom;
}
@end


