//
//  ALMyCenterViewModel.m
//  GMAlpha
//
//  Created by zhouLiang on 2018/11/26.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALMyCenterViewModel.h"
#import "ALMyCenterObject.h"

@implementation ALMyCenterViewModel

- (instancetype)initWithUserId:(NSInteger)userId
{
    self = [super init];
    if (self) {
        _remoteUrl = API_USER_CENTER;
        self.userId = userId;
    }
    return self;
}

- (void)buildParams{
    _params = @{
                @"user_id":@(self.userId),
                @"page":@(self.page),
                @"count":@(10)
                };
}

- (void)buildModelWithRemoteDic:(NSDictionary *)dic{
    if ([dic[@"error"] integerValue] != 0) {
        return;
    }
    NSDictionary *contentData = dic[@"data"];
    NSError *error = nil;
    self.contentObject = [[ALMyCenterObject alloc] initWithDictionary:contentData error:&error];
    [self.dataArray addObjectsFromArray:self.contentObject.cards];
}

@end
