//
//  ALDemoViewController.m
//  GMAlpha
//
//  Created by Mikasa on 2018/11/8.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALDemoViewController.h"
#import "ALTopicCommentListView.h"
#import "ALSetterUserInfoViewController.h"
#import "ALScanFaceHomeViewController.h"
#import "ALGroupListVController.h"
#import "ALTopicListVController.h"
#import "ALQAWebViewController.h"
#import "ALMatchingController.h"
#import "ALTransController.h"
#import "ALUnre2DViewController.h"
#import "ALFaceFittingViewController.h"
#import "FaceShowViewController.h"
#import "ALDownloadDemoViewController.h"
#import "ALScanFaceCompleteViewController.h"


@interface ALDemoViewController ()
@property (nonatomic, strong) NSArray *titleArray;
@property (nonatomic, strong) NSArray *actionArray;
@end

@implementation ALDemoViewController

- (void)initController {
    
    [super initController];
    self.immediateLoad = NO;
    _needHeaderRefresh = NO;
    _needFooterRefresh = NO;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"功能入口";
    [self.table mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.navigationBar.bottom);
    }];
    self.titleArray = @[@"评论列表",@"登录/注册",@"退出登录",@"设置用户信息",@"扫脸入口",@"小组详情列表",@"回答问题", @"帖子详情列表", @"拟合", @"模拟", @"下载",@"扫脸完成"];
    self.actionArray = @[@"aaa", @"bbb", @"ccc",@"ddd",@"eee",@"fff",@"ggg", @"hhh", @"unreTransSDK", @"matchingVc", @"download",@"scanComplete"];
    [self.table registerCell:[GMTableViewCell class]];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.titleArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    GMTableViewCell *cell = [tableView dequeueCell:[GMTableViewCell class] forIndexPath:indexPath];
    cell.textLabel.text = self.titleArray[indexPath.row];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    SEL selector = NSSelectorFromString(self.actionArray[indexPath.row]);
    [self performSelector:selector];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)aaa {
    
    ALTopicCommentListView *view = [[ALTopicCommentListView alloc] init];
    [self.view addSubview:view];
}

- (void)bbb {
    
    if ([[GMLoginManager shareInstance] showLoginViewIfNeeded]) {
        return;
    }
    
}

- (void)ccc {
    
    [[GMLoginManager shareInstance] shouldLogout];
    
}

- (void)ddd {
    ALSetterUserInfoViewController *setterUserCtrl = [[ALSetterUserInfoViewController alloc] init];
    [self.navigationController pushViewController:setterUserCtrl animated:YES];
}

- (void)eee {
    ALScanFaceHomeViewController  *scanFaceCtrl = [ALScanFaceHomeViewController new];
    [self.navigationController pushViewController:scanFaceCtrl animated:YES];
}

- (void)fff {
    
    ALGroupListVController *toVc = [[ALGroupListVController alloc] initWithGroupId:1];
    [self pushViewController:toVc];
}

- (void)ggg {
    
    ALQAWebViewController *qaVc = [ALQAWebViewController new];
//    qaVc.fullURL = [NSString stringWithFormat:@""];
    [self pushViewController:qaVc];
    
}

- (void)hhh {
    ALTopicListVController *qaVc = [[ALTopicListVController alloc] initWithTopicId:1];
    [self pushViewController:qaVc];
}

//- (void)beautyFaceSDK {
////    ALBeautyFaceController *vc = [[ALBeautyFaceController alloc] init];
////    [self pushViewController:vc];
//}

- (void)unreTransSDK {
    ALTransController *vc = [[ALTransController alloc] init];
    [self pushViewController:vc];
}

- (void)unreMatchSDK {
    ALMatchingController *vc =[[ALMatchingController alloc] init];
    [self pushViewController:vc];
}
- (void)iii {
    ALTopicListVController *qaVc = [[ALTopicListVController alloc] initWithTopicId:1];
    [self pushViewController:qaVc];
}

#pragma mark - Navigation

- (void)unre2DSDK {
    ALUnre2DViewController *controller = [[ALUnre2DViewController alloc] init];
    [self pushViewController:controller];
}

- (void)matchingVc {
    ALFaceFittingViewController *vc = [[ALFaceFittingViewController alloc] init];
    [self pushViewController:vc];
}

- (void)download {
    ALDownloadDemoViewController *vc = [[ALDownloadDemoViewController alloc] init];
    [self pushViewController:vc];
}

- (void)showFace {
    FaceShowViewController *vc = [[FaceShowViewController alloc] init];
    [self pushViewController:vc];
}

- (void)scanComplete {
    ALScanFaceCompleteViewController *vc = [[ALScanFaceCompleteViewController alloc] init];
    [self pushViewController:vc];
}
@end
