//
//  GMMessageController.m
//  GMAlpha
//
//  Created by Q14 on 2018/11/5.
//  Copyright © 2018年 Gengmei. All rights reserved.
//

#import "GMMessageController.h"
#import "ALTopicListVController.h"
#import "ALGroupListVController.h"
#import "ALDemoViewController.h"

@interface GMMessageController ()<WKWebViewDelegate>
@property (nonatomic, assign) BOOL needRefresh;
@end

@implementation GMMessageController

- (void)initController {
    
    [super initController];
    self.navigationBar.title = @"消息";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
#ifndef APPSTORE
    self.navigationBar.rightTitle = @"功能入口";
#endif
    
    
    self.webCompent.delegate = self;
    [self.webCompent mas_updateConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(0);
    }];
    self.path = API_ALPHA_NOTICE;
    [self reloadURL];
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    if (self.needRefresh) {
        [self refreshWebView];
        self.needRefresh = NO;
    }
}

- (void)viewDidDisappear:(BOOL)animated {
    
    [super viewDidDisappear:animated];
    self.needRefresh = YES;
}

- (void)globalDataLoaded:(NSDictionary *)data {
    
    [self trackEventGlobalPage:data];
    [AppDelegate tabBarController].pageName = self.pageName;
    
}

#ifndef APPSTORE
- (void)rightButtonClicked:(OCNavigationBarButton *)button {
    [AppDelegate.navigation pushViewController:[ALDemoViewController new] animated:YES];
}
#endif
@end
