//
//  GMPushCtrlObject.h
//  Pods
//
//  Created by wangyang on 16/8/9.
//
//

#import <Foundation/Foundation.h>

/* 1 开始会话, 2 客服完成会话, 3 客服超时提示, 4 用户超时下线, 5 排队超时下线, 6 下发系统消息 */
typedef NS_ENUM(NSInteger, GMPushCtrlType){
    GMPushCtrlTypeDefault = 0,
    GMPushCtrlTypeBeginTalk = 1,
    GMPushCtrlTypeEndTalk = 2,
    GMPushCtrlTypeServiceOverTime = 3,
    GMPushCtrlTypeCustomerOverTime = 4,
    GMPushCtrlTypeQueueOverTime = 5,
    GMPushCtrlTypeQueueSendSystemMsg = 6,
};

@interface GMPushCtrlObject : GMObject
/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 客户端的业务文案
 *
 *  @since 5.9.4
 */
@property(nonatomic , strong) NSString *content;

/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 用于扩展，目前暂时用到1
 *
 *  @since 5.9.4
 */
@property(nonatomic , assign) NSInteger ctrlType;

/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 会话状态。 value：1.开始会话, 2.客服完成会话, 3.客服超时提示, 4.用户超时下线, 5 排队超时下线
 *
 *  @since 5.9.4
 */
@property(nonatomic , assign) GMPushCtrlType ctrlCode;

/*!
 *  @author zhaiguojun, 16-04-28
 *
 *  @brief 会话id
 *
 *  @since 5.9.4
 */
@property(nonatomic , strong) NSString *userKey;

@end
